/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.jbotester.JBOControl;
import oracle.jbo.jbotester.JBOTreeModel;
import oracle.jbo.jbotester.JBOTreeNode;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.RowSetPanel;

public final class TreePanel
extends JScrollPane
implements JBOControl {
    private final JTree tree = new JTree(new DefaultMutableTreeNode(Res.getString(222)));
    private JBOTreeModel model;
    private String accessor;
    private RowSetPanel rowSetPanel;
    private RowSetIterator iter;

    public TreePanel(MainFrame mainFrame) {
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setLargeModel(true);
        this.tree.addTreeExpansionListener(new JBOTreeExpansionListener());
        this.tree.addTreeSelectionListener(new JBOTreeSelectionListener());
        this.setViewportView(this.tree);
    }

    public void setRowSetPanel(RowSetPanel rowSetPanel) {
        this.rowSetPanel = rowSetPanel;
    }

    public void setAccessorName(String string) {
        this.accessor = string;
    }

    public void setIterator(RowSetIterator rowSetIterator) {
        if (this.iter == rowSetIterator) {
            return;
        }
        if (this.iter != null) {
            this.iter.removeListener((Object)this);
        }
        this.iter = rowSetIterator;
        if (this.iter == null) {
            return;
        }
        if (this.iter.getRowSet().getViewObject().isReadOnly()) {
            // empty if block
        }
        this.iter.addListener((Object)this);
        this.changeModelTo(this.iter.getCurrentRow());
    }

    public RowSetIterator getIterator() {
        return this.iter;
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.changeModelTo(navigationEvent.getRow());
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
    }

    public void rowInserted(InsertEvent insertEvent) {
    }

    private void changeModelTo(Row row) {
        this.model = new JBOTreeModel(row, this.accessor);
        this.tree.setModel(this.model);
        TreePath treePath = this.tree.getPathForRow(0);
        if (((JBOTreeNode)treePath.getLastPathComponent()).getAllowsChildren()) {
            this.tree.fireTreeExpanded(treePath);
        }
        this.tree.setSelectionPath(treePath);
    }

    private final class JBOTreeExpansionListener
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            JBOTreeNode jBOTreeNode = (JBOTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            if (jBOTreeNode.expand()) {
                int n = jBOTreeNode.getChildCount();
                int[] nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = n2;
                    ++n2;
                }
                TreePanel.this.model.nodesWereInserted(jBOTreeNode, nArray);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        private JBOTreeExpansionListener() {
        }
    }

    private final class JBOTreeSelectionListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MutableTreeNode mutableTreeNode;
            if (TreePanel.this.rowSetPanel != null && (mutableTreeNode = (MutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent()) instanceof JBOTreeNode) {
                TreePanel.this.rowSetPanel.refreshAll(((JBOTreeNode)mutableTreeNode).getRow());
            }
        }

        private JBOTreeSelectionListener() {
        }
    }
}

