/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.JTScrollPane;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.NavBar;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.RowSetPanel;

public class SimpleForm
extends JPanel {
    private final MainFrame mainFrame;
    private final RowSetPanel masterPanel;
    private final NavBar toolBar;
    private final ObjTreeNode node;
    protected final JScrollPane scroller;

    public SimpleForm(MainFrame mainFrame, ObjTreeNode objTreeNode) {
        this(mainFrame, objTreeNode, null);
    }

    public SimpleForm(MainFrame mainFrame, ObjTreeNode objTreeNode, ViewObject viewObject) {
        super(new BorderLayout(), false);
        this.mainFrame = mainFrame;
        this.node = objTreeNode;
        this.masterPanel = new RowSetPanel(mainFrame);
        this.scroller = new JTScrollPane(this.masterPanel);
        this.toolBar = new NavBar(this.mainFrame);
        this.add((Component)this.toolBar, "North");
        if (viewObject != null) {
            this.setIterator((RowSetIterator)viewObject);
        }
        this.add((Component)this.scroller, "Center");
    }

    public final void setIterator(RowSetIterator rowSetIterator) {
        ViewObject viewObject;
        boolean bl;
        if (rowSetIterator != null && (bl = JboTesterUtil.hasBindParameters(viewObject = rowSetIterator.getRowSet().getViewObject()))) {
            JboTesterUtil.editBindParameters(MainFrame.getInstance(), viewObject);
        }
        this.toolBar.setIterator(rowSetIterator);
        if (this.masterPanel.getIterator() == null) {
            rowSetIterator.getRowSet().executeQuery();
        }
        if (rowSetIterator != null) {
            this.toolBar.setMyParent(this);
        }
        this.masterPanel.setIterator(rowSetIterator);
    }

    public final RowSetIterator getIterator() {
        return this.masterPanel.getIterator();
    }

    public final ObjTreeNode getTreeNode() {
        return this.node;
    }

    public final MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public final void refreshAll() {
        this.masterPanel.refreshAll(this.getIterator().getCurrentRow());
    }

    public boolean applyEditsAndValidate() {
        boolean bl = true;
        if (this.masterPanel != null) {
            bl = this.masterPanel.applyEditsAndValidate();
        }
        return bl;
    }
}

