/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import oracle.jbo.AttributeDef;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.jbotester.JBOField;
import oracle.jbo.jbotester.JBOFieldHelper;

public final class RowsetTextField
extends JTextField
implements JBOField {
    private final JBOFieldHelper jboField;
    private final LocaleContext locale;

    public RowsetTextField(int n, AttributeDef attributeDef, LocaleContext localeContext) {
        super(n);
        this.jboField = new JBOFieldHelper(attributeDef, this);
        this.locale = localeContext;
        this.addActionListener(JBOFieldHelper.UpdateActionListener);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        Keymap keymap = this.getKeymap();
        if (keymap.getAction(keyStroke) != JBOFieldHelper.CancelAction) {
            keymap.addActionForKeyStroke(keyStroke, JBOFieldHelper.CancelAction);
        }
        this.jboField.init();
    }

    public JComponent getJComponent() {
        return this;
    }

    public LocaleContext getLocaleContext() {
        return this.locale;
    }

    public Object getControlValue() {
        return this.getText();
    }

    public void setControlValue(Object object) {
        this.setText(object != null ? object.toString() : "");
    }

    public void setRow(Row row, RowSetIterator rowSetIterator) {
        this.jboField.setRow(row, rowSetIterator);
    }

    public AttributeDef getAttributeDef() {
        return this.jboField.getAttributeDef();
    }

    public Object getDataValue() {
        return this.jboField.getDataValue();
    }

    public boolean setDataValue(Object object) {
        return this.jboField.setDataValue(object);
    }

    public boolean applyEdit() {
        return this.jboField.applyEdit();
    }

    public boolean applyEditAndValidate() {
        return this.jboField.applyEditAndValidate();
    }

    public void refresh() {
        this.jboField.refresh();
    }
}

