/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.AttDefDialog;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JBOControl;
import oracle.jbo.jbotester.JBOControlMouseAdapter;
import oracle.jbo.jbotester.JBOField;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.RowsetTextArea;
import oracle.jbo.jbotester.RowsetTextField;

public final class RowSetPanel
extends JPanel
implements JBOControl {
    private static final int MAXGRIDSIZE = 512;
    private RowSetIterator iter;
    private JBOField[] fields;
    protected final MainFrame mainFrame;
    private ArrayList enabledControls;
    private static /* synthetic */ Class class$oracle$jbo$domain$Date;

    private /* synthetic */ void $init$() {
        this.enabledControls = new ArrayList();
    }

    public RowSetPanel(MainFrame mainFrame) {
        super(new GridBagLayout());
        this.$init$();
        this.mainFrame = mainFrame;
    }

    public void setIterator(RowSetIterator rowSetIterator) {
        if (this.iter == rowSetIterator) {
            return;
        }
        if (this.iter != null) {
            this.iter.removeListener((Object)this);
        }
        this.iter = rowSetIterator;
        if (this.iter == null) {
            return;
        }
        ViewObject viewObject = this.iter.getRowSet().getViewObject();
        if (viewObject.isReadOnly()) {
            // empty if block
        }
        this.iter.addListener((Object)this);
        AttributeDef[] attributeDefArray = JboTesterUtil.getDisplayableAttributes(this.iter.getRowSet());
        this.fields = new JBOField[attributeDefArray.length];
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        Font font = null;
        LocaleContext localeContext = this.iter.getRowSet().getApplicationModule().getSession().getLocaleContext();
        int n2 = 0;
        while (n2 < attributeDefArray.length) {
            JTextComponent jTextComponent;
            JComponent jComponent3;
            AttributeDef attributeDef = attributeDefArray[n2];
            AttributeHints attributeHints = attributeDef.getUIHelper();
            JLabel jLabel = new JLabel(attributeHints.getLabel(localeContext) + ":");
            jLabel.setEnabled(attributeDef.getUpdateableFlag() != 0);
            jLabel.addMouseListener(new LabelMouseAdapter(attributeDef));
            int n3 = attributeHints.getDisplayHeight(localeContext);
            int n4 = (attributeHints.getDisplayWidth(localeContext) * 3 + 1) / 2;
            int n5 = attributeHints.getControlType(localeContext);
            String string = attributeHints.getTooltip(localeContext);
            if (n4 <= 0) {
                Class clazz = attributeDef.getJavaType();
                Class clazz2 = class$oracle$jbo$domain$Date;
                if (clazz2 == null) {
                    clazz2 = RowSetPanel.class$("oracle.jbo.domain.Date");
                }
                n4 = clazz.equals(clazz2) ? 15 : 10;
            }
            if (n4 > 50 && n5 == 100 && n3 == 1) {
                n3 = 3;
                n4 = 50;
            }
            if (n3 > 1) {
                RowsetTextArea rowsetTextArea = new RowsetTextArea(attributeDef, localeContext);
                ((JTextArea)rowsetTextArea.getJComponent()).setColumns(n4);
                ((JTextArea)rowsetTextArea.getJComponent()).setRows(n3);
                if (string != null) {
                    rowsetTextArea.getJComponent().setToolTipText(string);
                }
                if (font != null) {
                    font = new JTextField().getFont();
                }
                ((JTextArea)rowsetTextArea.getJComponent()).setFont(font);
                jComponent3 = rowsetTextArea.getScrollPane();
                jTextComponent = rowsetTextArea;
            } else {
                jTextComponent = new RowsetTextField(n4, attributeDef, localeContext);
                jComponent3 = jTextComponent.getJComponent();
                font = ((JTextField)jComponent3).getFont();
                if (string != null) {
                    jComponent3.setToolTipText(string);
                }
            }
            this.fields[n2] = jTextComponent;
            jTextComponent.getJComponent().setEnabled(attributeDef.getUpdateableFlag() != 0);
            jLabel.setLabelFor(jTextComponent.getJComponent());
            if (jComponent == null) {
                jComponent = jTextComponent.getJComponent();
            }
            jComponent2 = jTextComponent.getJComponent();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = Math.round(n2 / 512) * 2;
            gridBagConstraints.gridy = n++ - 512 * gridBagConstraints.gridx / 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jLabel, gridBagConstraints);
            if (attributeDefArray.length < 512) {
                if (attributeDef.getSQLType() == 2002) {
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 0;
                } else {
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = -1;
                }
            }
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = -1;
            this.add((Component)jComponent3, gridBagConstraints);
            if (jLabel.isEnabled()) {
                this.enabledControls.add(jLabel);
                this.enabledControls.add(jTextComponent);
            }
            ++n2;
        }
        if (!this.iter.hasNext()) {
            this.setControlsEnabled(false);
        }
        this.refreshAll(this.iter.getCurrentRow());
    }

    public RowSetIterator getIterator() {
        return this.iter;
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (rangeRefreshEvent.getRowCountInRange() == 0) {
            RowIterator rowIterator = (RowIterator)rangeRefreshEvent.getSource();
            if (rowIterator.getCurrentRowSlot() == 2) {
                rowIterator.first();
            }
            this.refreshAll(rowIterator.getCurrentRow());
        }
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        if (this.fields == null) {
            return;
        }
        if (updateEvent.getRow() == ((RowIterator)updateEvent.getSource()).getCurrentRow()) {
            int[] nArray = updateEvent.getChangedAttrIndices();
            if (nArray == null) {
                this.refreshAll(updateEvent.getRow());
            } else {
                int n = 0;
                while (n < nArray.length) {
                    int n2 = 0;
                    while (n2 < this.fields.length) {
                        JBOField jBOField = this.fields[n2];
                        if (jBOField.getAttributeDef().getIndex() == nArray[n]) {
                            jBOField.setRow(updateEvent.getRow(), this.getIterator());
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.refreshAll(navigationEvent.getRow());
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        SwingUtilities.invokeLater(new 1());
        if (!this.iter.hasNext() && !this.iter.hasPrevious()) {
            this.setControlsEnabled(false);
        }
    }

    public void rowInserted(InsertEvent insertEvent) {
        this.setControlsEnabled(true);
    }

    public void refreshAll(Row row) {
        if (this.fields == null) {
            return;
        }
        try {
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n].setRow(row, this.getIterator());
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception exception) {
            ErrorHandler.displayError((Frame)this.mainFrame, exception);
        }
    }

    boolean applyEditsAndValidate() {
        if (this.iter.getCurrentRowSlot() == 1 || this.iter.getCurrentRow() == null || this.iter.getCurrentRow().isDead()) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.fields.length) {
            bl = this.fields[n].applyEditAndValidate();
            if (!bl) break;
            ++n;
        }
        return bl;
    }

    private void setControlsEnabled(boolean bl) {
        int n = 0;
        while (n < this.enabledControls.size()) {
            ((JComponent)this.enabledControls.get(n)).setEnabled(bl);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            try {
                if (RowSetPanel.this.iter.getCurrentRowSlot() == 1) {
                    if (RowSetPanel.this.iter.hasNext()) {
                        RowSetPanel.this.iter.next();
                    } else if (RowSetPanel.this.iter.hasPrevious()) {
                        RowSetPanel.this.iter.previous();
                    } else {
                        RowSetPanel.this.refreshAll(null);
                    }
                }
            }
            catch (Exception exception) {
                ErrorHandler.displayError((Frame)RowSetPanel.this.mainFrame, exception);
            }
        }
    }

    public final class LabelMouseAdapter
    extends JBOControlMouseAdapter {
        private AttributeDef attrDef;
        private AttDefDialog mDlg;

        LabelMouseAdapter(AttributeDef attributeDef) {
            super(RowSetPanel.this.mainFrame);
            this.attrDef = attributeDef;
        }

        public AttributeDef getAttributeDef(MouseEvent mouseEvent) {
            return this.attrDef;
        }

        public AttDefDialog getAttrDefDialog(AttributeDef attributeDef, MainFrame mainFrame) {
            if (this.mDlg == null) {
                this.mDlg = new AttDefDialog(attributeDef, mainFrame);
            }
            return this.mDlg;
        }
    }
}

