/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.jbo.ComponentObject;
import oracle.jbo.jbotester.AbstractJboAction;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.properties.PropertyDialog;
import oracle.jbo.jbotester.properties.PropertyPanel;

public abstract class ObjTreeNode
extends DefaultMutableTreeNode {
    public static final int APP_MODULE = 0;
    public static final int VIEW_OBJECT = 1;
    public static final int VIEW_LINK = 2;
    public static final int APP_MODULE_BRANCH = 3;
    public static final int VIEW_OBJECT_BRANCH = 4;
    public static final int VIEW_LINK_BRANCH = 5;
    public static final Action createVOAction = new CreateViewObjectAction();
    public static final Action createVLAction = new CreateViewLinkAction();
    public static final Action createAMAction = new CreateApplicationModuleAction();
    private Action findAction;
    private Action reExecuteAction;
    private Action reBindParameterAction;
    protected Action removeAction;
    protected JPopupMenu popupMenu;

    public ObjTreeNode(String string) {
        super(string);
    }

    public abstract String getName();

    public String getFullName() {
        return null;
    }

    public abstract Object getData();

    public abstract void setData(Object var1);

    public abstract int getType();

    public abstract ImageIcon getIcon();

    public void showForm() {
    }

    public String getStatus() {
        return " ";
    }

    public void handleEvent(ActionEvent actionEvent) {
    }

    public JPopupMenu getMenu() {
        return null;
    }

    public void remove() {
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            ((ObjTreeNode)this.getChildAt(n)).remove();
            --n;
        }
        MainFrame.getInstance().getBaseTree().removeFromParent(this);
    }

    public void showProperties() {
    }

    public String toString() {
        return this.getName();
    }

    public final ObjTreeNode getChildOfName(String string) {
        ObjTreeNode objTreeNode = null;
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            objTreeNode = (ObjTreeNode)enumeration.nextElement();
            if (string.equals(objTreeNode.getName())) break;
        }
        return objTreeNode;
    }

    public final ObjTreeNode getParentOfType(int n) {
        if (this.getType() == n) {
            return this;
        }
        ObjTreeNode objTreeNode = (ObjTreeNode)this.getParent();
        if (objTreeNode == null) {
            return null;
        }
        return objTreeNode.getParentOfType(n);
    }

    public final boolean isFormDisplayed(ComponentObject componentObject) {
        JPanel jPanel;
        boolean bl = true;
        bl = componentObject != null ? (jPanel = ResultWindow.getResultWindow().getTab(componentObject.getFullName())) != null : false;
        return bl;
    }

    protected boolean isBindParameterActionEnabled(ComponentObject componentObject) {
        return false;
    }

    protected final JPopupMenu createVOVLMenu(ComponentObject componentObject) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new ShowAction());
            if (this.removeAction == null) {
                this.removeAction = new RemoveAction();
            }
            this.popupMenu.add(this.removeAction);
            if (this.findAction == null) {
                this.findAction = new HandleEventAction(Res.getString(197));
            }
            this.popupMenu.add(this.findAction);
            if (this.reExecuteAction == null) {
                this.reExecuteAction = new HandleEventAction(Res.getString(198));
            }
            this.popupMenu.add(this.reExecuteAction);
            if (this.reBindParameterAction == null) {
                this.reBindParameterAction = new HandleEventAction(Res.getString(204));
            }
            this.popupMenu.add(this.reBindParameterAction);
            this.popupMenu.addSeparator();
            this.popupMenu.add(new PropertiesAction());
        }
        boolean bl = this.isFormDisplayed(componentObject);
        this.findAction.setEnabled(bl);
        this.reExecuteAction.setEnabled(bl);
        this.reBindParameterAction.setEnabled(this.isBindParameterActionEnabled(componentObject));
        return this.popupMenu;
    }

    protected final void showPropertyDialog(Object object, BeanInfo beanInfo, int n) {
        PropertyPanel propertyPanel = new PropertyPanel(MainFrame.getInstance(), object, beanInfo);
        PropertyDialog propertyDialog = new PropertyDialog(MainFrame.getInstance(), Res.getString(n), propertyPanel);
        propertyDialog.setHelpLocation("f1_bcbctproperties_html");
        propertyDialog.show();
    }

    public static final class CreateViewObjectAction
    extends AbstractJboAction {
        public CreateViewObjectAction() {
            super(Res.getString(201));
        }

        protected MainFrame getMainFrame() {
            return MainFrame.getInstance();
        }

        protected void doAction(ActionEvent actionEvent) {
            this.getMainFrame().getBaseTree().createDynViewObject();
        }
    }

    public static final class CreateViewLinkAction
    extends AbstractJboAction {
        public CreateViewLinkAction() {
            super(Res.getString(202));
        }

        protected MainFrame getMainFrame() {
            return MainFrame.getInstance();
        }

        public void doAction(ActionEvent actionEvent) {
            this.getMainFrame().getBaseTree().createDynViewLink();
        }
    }

    public static final class CreateApplicationModuleAction
    extends AbstractJboAction {
        public CreateApplicationModuleAction() {
            super(Res.getString(203));
        }

        protected MainFrame getMainFrame() {
            return MainFrame.getInstance();
        }

        public void doAction(ActionEvent actionEvent) {
            this.getMainFrame().getBaseTree().createApplicationModule();
        }
    }

    public abstract class AbstractNodeAction
    extends AbstractJboAction {
        public AbstractNodeAction(String string) {
            super(string);
        }

        public AbstractNodeAction(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected MainFrame getMainFrame() {
            return MainFrame.getInstance();
        }
    }

    public final class HandleEventAction
    extends AbstractNodeAction {
        public HandleEventAction(String string) {
            super(string);
        }

        public void doAction(ActionEvent actionEvent) {
            ObjTreeNode.this.handleEvent(actionEvent);
        }
    }

    public final class RemoveAction
    extends AbstractNodeAction {
        public RemoveAction() {
            super(Res.getString(199));
        }

        public void doAction(ActionEvent actionEvent) {
            ObjTreeNode.this.remove();
        }
    }

    public final class PropertiesAction
    extends AbstractNodeAction {
        public PropertiesAction() {
            super(Res.getString(200));
        }

        public void doAction(ActionEvent actionEvent) {
            ObjTreeNode.this.showProperties();
        }
    }

    public final class ShowAction
    extends AbstractNodeAction {
        public ShowAction() {
            super(Res.getString(196));
        }

        public void doAction(ActionEvent actionEvent) {
            ObjTreeNode.this.showForm();
        }
    }
}

