/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import oracle.bali.share.nls.StringUtils;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewObject;
import oracle.jbo.client.JboUtil;
import oracle.jbo.domain.Array;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.VCDialog;
import oracle.jbo.jbotester.VariableDialog;
import oracle.xml.parser.v2.XMLElement;

public final class JboTesterUtil {
    public static final String EJB_CLIENT_JARS = "EjbClientJars";
    public static final String IMAGELOC = "images/";
    private static /* synthetic */ Class class$oracle$jbo$jbotester$JboTesterUtil;

    public static void centerWindow(Window window) {
        int n;
        Dimension dimension = window.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension2.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (dimension2.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        window.setLocation(n2, n);
    }

    public static String getDataAsXML(ViewObject viewObject) {
        String string;
        XMLElement xMLElement = (XMLElement)viewObject.writeXML(10, (long)2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = "UTF-8";
        try {
            xMLElement.print((OutputStream)byteArrayOutputStream, string2);
            string = byteArrayOutputStream.toString(string2);
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            ErrorHandler.displayError(null, exception);
            string = new String();
        }
        return string;
    }

    public static AttributeDef[] getDisplayableAttributes(RowSet rowSet) {
        AttributeDef[] attributeDefArray = rowSet.getViewObject().getAttributeDefs();
        LocaleContext localeContext = rowSet.getApplicationModule().getSession().getLocaleContext();
        ArrayList arrayList = new ArrayList(attributeDefArray.length);
        int n = 0;
        while (n < attributeDefArray.length) {
            if (JboUtil.isAttributeDisplayable((AttributeDef)attributeDefArray[n], (LocaleContext)localeContext)) {
                arrayList.add((Object)attributeDefArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == attributeDefArray.length) {
            return attributeDefArray;
        }
        return (AttributeDef[])arrayList.toArray((Object[])new AttributeDef[arrayList.size()]);
    }

    public static ImageIcon getIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            Class clazz;
            if (!string.startsWith("/")) {
                string = IMAGELOC + string;
            }
            if ((clazz = class$oracle$jbo$jbotester$JboTesterUtil) == null) {
                clazz = class$oracle$jbo$jbotester$JboTesterUtil = JboTesterUtil.class$("oracle.jbo.jbotester.JboTesterUtil");
            }
            URL uRL = clazz.getResource(string);
            imageIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }

    public static void removeKeyBindingCompatibility(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    public static void createViewCriteria(MainFrame mainFrame, ViewObject viewObject) {
        VCDialog vCDialog = new VCDialog(mainFrame, viewObject);
        if (vCDialog.attribs == null || vCDialog.attribs.length == 0) {
            ErrorHandler.displayError((Frame)mainFrame, Res.getString(67));
            return;
        }
        vCDialog.show();
    }

    public static void editBindParameters(MainFrame mainFrame, ViewObject viewObject) {
        VariableDialog variableDialog = new VariableDialog(mainFrame, viewObject);
        variableDialog.show();
    }

    public static boolean hasBindParameters(ViewObject viewObject) {
        Variable[] variableArray;
        viewObject.ensureVariableManager();
        VariableValueManager variableValueManager = viewObject.getVariableManager();
        return variableValueManager != null && (variableArray = variableValueManager.getVariablesOfKind("where")) != null && variableArray.length > 0;
    }

    public static void setData(Row row, AttributeDef attributeDef, LocaleContext localeContext, Object object) {
        AttributeHints attributeHints = attributeDef.getUIHelper();
        if (attributeHints.hasFormatInformation(localeContext)) {
            object = attributeHints.parseFormattedAttribute((String)object, localeContext);
        }
        row.setAttribute(attributeDef.getIndex(), object);
    }

    public static Object getData(Row row, AttributeDef attributeDef, LocaleContext localeContext) {
        AttributeHints attributeHints = attributeDef.getUIHelper();
        if (attributeHints.hasFormatInformation(localeContext)) {
            return attributeHints.getFormattedAttribute((AttributeList)row, localeContext);
        }
        Object object = row.getAttribute(attributeDef.getIndex());
        if (attributeDef.getSQLType() == 2003) {
            Array array = (Array)object;
            Object[] objectArray = null;
            int n = 0;
            if (array != null) {
                objectArray = array.getArray();
            }
            if (objectArray != null) {
                n = objectArray.length;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(objectArray[n2]);
                stringBuffer.append(',');
                ++n2;
            }
            if (n > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            stringBuffer.append(']');
            return stringBuffer;
        }
        return object;
    }

    public static void setMnemonic(JButton jButton, int n) {
        int n2 = JboTesterUtil.getMnemonicKeyCode(n);
        if (n2 != 0) {
            jButton.setMnemonic(n2);
        }
    }

    public static String stripMnemonic(int n) {
        return JboTesterUtil.stripMnemonic(Res.getString(n));
    }

    public static String stripMnemonic(String string) {
        return StringUtils.stripMnemonic((String)string);
    }

    public static int getMnemonicKeyCode(int n) {
        return JboTesterUtil.getMnemonicKeyCode(Res.getString(n));
    }

    public static int getMnemonicKeyCode(String string) {
        return StringUtils.getMnemonicKeyCode((String)string);
    }

    public static JButton createButton(int n) {
        return JboTesterUtil.createButton(Res.getString(n));
    }

    public static JButton createButton(String string) {
        JButton jButton = new JButton(JboTesterUtil.stripMnemonic(string));
        int n = JboTesterUtil.getMnemonicKeyCode(string);
        if (n != 0) {
            jButton.setMnemonic(n);
        }
        return jButton;
    }

    public static JCheckBox createCheckBox(int n) {
        return JboTesterUtil.createCheckBox(Res.getString(n));
    }

    public static JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(JboTesterUtil.stripMnemonic(string));
        int n = JboTesterUtil.getMnemonicKeyCode(string);
        if (n != 0) {
            jCheckBox.setMnemonic(n);
        }
        return jCheckBox;
    }

    public static JLabel createLabel(int n, Component component) {
        JLabel jLabel = new JLabel(JboTesterUtil.stripMnemonic(n));
        int n2 = JboTesterUtil.getMnemonicKeyCode(n);
        if (n2 != 0) {
            jLabel.setDisplayedMnemonic(n2);
            jLabel.setLabelFor(component);
        }
        return jLabel;
    }

    public static void addSpacerPanel(JPanel jPanel, int n, int n2) {
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

