/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.jbo.jbotester.HelpManager;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;

public abstract class JTDialog
extends JDialog {
    public static final String CANCEL_ACTION = "cancel";
    private String helpLocation;
    private boolean isRegisteredToHelp;
    protected final CancelAction cancelAction;
    protected final AbstractAction helpAction;
    protected final Frame parent;

    private /* synthetic */ void $init$() {
        this.cancelAction = new CancelAction();
        this.helpAction = new HelpAction();
    }

    protected JTDialog(Frame frame, int n) {
        this(frame, Res.getString(n));
    }

    protected JTDialog(Frame frame, String string) {
        super(frame, string, true);
        this.$init$();
        this.parent = frame;
        this.registerKeyboardActions();
        this.setHelpLocation(HelpManager.getHelpTopic(this));
    }

    public void close() {
        if (this.isRegisteredToHelp) {
            WindowUtils.unregisterWindow((Window)this);
            this.isRegisteredToHelp = false;
        }
        this.setVisible(false);
        this.dispose();
    }

    public String getHelpLocation() {
        return this.helpLocation;
    }

    public void setHelpLocation(String string) {
        this.helpLocation = string;
    }

    public void show() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
        super.show();
    }

    private final void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        jRootPane.registerKeyboardAction(this.cancelAction, CANCEL_ACTION, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void cancel() {
    }

    protected void save() {
    }

    protected void doHelp() {
        if (this.parent instanceof MainFrame) {
            if (!this.isRegisteredToHelp) {
                this.isRegisteredToHelp = true;
                WindowUtils.registerWindow((Window)this);
            }
            ((MainFrame)this.parent).helpMe(this.helpLocation);
        }
    }

    private final class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(JboTesterUtil.stripMnemonic(Res.getString(60)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTDialog.this.cancel();
            JTDialog.this.close();
        }
    }

    private final class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super(JboTesterUtil.stripMnemonic(Res.getString(62)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTDialog.this.doHelp();
        }
    }
}

