/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarDirectoryStorage;
import oracle.ojc.storage.JarFileStorage;

public final class JarStorage
extends DirectoryStorage {
    RandomAccessFile r;

    public JarStorage(AbstractStorage abstractStorage, String string) {
        super(abstractStorage, string);
        this.readJarDirectory();
    }

    public JarStorage(File file) {
        super(file);
        this.readJarDirectory();
    }

    private void readJarDirectory() {
        try {
            this.r = new RandomAccessFile(this.file, "r");
            byte[] byArray = this.findDir();
            int n = JarStorage.get2LE(byArray, 0);
            int n2 = 2;
            for (int i = 0; i < n; ++i) {
                n2 = this.readEntry(byArray, n2);
            }
        }
        catch (IOException iOException) {
            this.r = null;
        }
    }

    private byte[] findDir() throws IOException {
        byte[] byArray = new byte[1024];
        int n = byArray.length;
        long l = this.r.length();
        while (l >= 22L) {
            int n2;
            if (l < (long)n) {
                n = (int)l;
            }
            long l2 = l - (long)n;
            this.r.seek(l2);
            if (this.r.read(byArray, 0, n) != n) {
                throw new IOException("read error");
            }
            for (n2 = n - 22; n2 >= 0 && (byArray[n2] != 80 || byArray[n2 + 1] != 75 || byArray[n2 + 2] != 5 || byArray[n2 + 3] != 6 || l2 + (long)n2 + 22L + (long)JarStorage.get2LE(byArray, n2 + 20) != this.r.length()); --n2) {
            }
            if (n2 >= 0) {
                byte[] byArray2 = new byte[JarStorage.get4LE(byArray, n2 + 12) + 2];
                byArray2[0] = byArray[n2 + 10];
                byArray2[1] = byArray[n2 + 11];
                this.r.seek(JarStorage.get4LE(byArray, n2 + 16));
                if (this.r.read(byArray2, 2, byArray2.length - 2) != byArray2.length - 2) {
                    throw new IOException("read error");
                }
                return byArray2;
            }
            l = l2 + 21L;
        }
        throw new IOException("bad zip file");
    }

    private int readEntry(byte[] byArray, int n) throws IOException {
        String string;
        if (JarStorage.get4LE(byArray, n) != 33639248) {
            throw new IOException("bad dir entry");
        }
        int n2 = JarStorage.get4LE(byArray, n + 20);
        int n3 = JarStorage.get4LE(byArray, n + 24);
        int n4 = JarStorage.get4LE(byArray, n + 42);
        int n5 = JarStorage.get2LE(byArray, n + 28);
        char[] cArray = new char[n5];
        int n6 = 0;
        DirectoryStorage directoryStorage = this;
        block3: for (int i = 0; i < n5; ++i) {
            byte by = byArray[n + 46 + i];
            switch (by) {
                default: {
                    cArray[n6++] = (char)(by & 0xFF);
                    continue block3;
                }
                case 47: 
                case 92: {
                    string = new String(cArray, 0, n6);
                    n6 = 0;
                    DirectoryStorage directoryStorage2 = (DirectoryStorage)directoryStorage.find(string);
                    if (directoryStorage2 != null) {
                        directoryStorage = directoryStorage2;
                        continue block3;
                    }
                    JarDirectoryStorage jarDirectoryStorage = new JarDirectoryStorage(directoryStorage, string);
                    directoryStorage.entries.put(string, jarDirectoryStorage);
                    directoryStorage = jarDirectoryStorage;
                }
            }
        }
        string = new String(cArray, 0, n6);
        JarFileStorage jarFileStorage = new JarFileStorage(this, directoryStorage, string, n4, n3, n2);
        directoryStorage.entries.put(string, jarFileStorage);
        return n + 46 + JarStorage.get2LE(byArray, n + 28) + JarStorage.get2LE(byArray, n + 30) + JarStorage.get2LE(byArray, n + 32);
    }

    static int get2LE(byte[] byArray, int n) {
        return ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    static int get4LE(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public void close() {
        try {
            if (this.r != null) {
                this.r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.r = null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public Storage create(String string) throws IOException {
        throw new IOException("read only");
    }

    public Storage createDir(String string) throws IOException {
        throw new IOException("read only");
    }
}

