/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.VariableExpression;

class ThisExpression
extends VariableExpression {
    RawClassSymbol classSymbol;
    TypeSymbol outerClassSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ThisExpression(int n, RawClassSymbol rawClassSymbol) {
        super(n);
        this.classSymbol = rawClassSymbol;
    }

    short getAccess() {
        return 16;
    }

    String errorName() {
        return "this";
    }

    Expression resolveAndCheck(Parser parser) {
        RawClassSymbol rawClassSymbol;
        if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) {
            Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "this");
            return new ErrorExpression(error);
        }
        if (this.outerClassSymbol != null) {
            TypeSymbol typeSymbol = this.outerClassSymbol.resolveType(parser, this.pos, true, true, false);
            if (typeSymbol.typeKind != 10) {
                Error error = parser.error(Message.errorObjectRequired, this.pos, typeSymbol.isErroneous(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
            this.outerClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
            if (this.classSymbol.equalTo(this.outerClassSymbol)) {
                this.outerClassSymbol = null;
                rawClassSymbol = this.classSymbol;
            } else {
                if (!this.classSymbol.isInnerClass((RawClassSymbol)this.outerClassSymbol)) {
                    Error error = parser.error(Message.errorIllegalQualifierNotInner, this.pos, false, this.outerClassSymbol.errorName());
                    return new ErrorExpression(error);
                }
                RawClassSymbol rawClassSymbol2 = this.classSymbol;
                while (!rawClassSymbol2.equalTo(this.outerClassSymbol) && rawClassSymbol2.isInnerClass()) {
                    if ((rawClassSymbol2.access & 8) != 0) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "this");
                        return new ErrorExpression(error);
                    }
                    rawClassSymbol2 = rawClassSymbol2.getOuterClass();
                }
                rawClassSymbol = (RawClassSymbol)this.outerClassSymbol;
            }
        } else {
            rawClassSymbol = this.classSymbol;
        }
        this.setType(ParameterizedClassSymbol.getParameterizedClassSymbol(rawClassSymbol, TypeVariableList.newTypeVariableList(rawClassSymbol.cd.getTypeParameterList()), null));
        return this;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
        return this.resolveAndCheck(parser);
    }

    Expression resolveAndCheckWrite(Parser parser) {
        parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
        return this.resolveAndCheck(parser);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor() || this.outerClassSymbol == null) {
            byteCodeGenerator.loadLocalVariable(this.getType(), (short)0);
        }
        if (this.outerClassSymbol != null) {
            byteCodeGenerator.generateOuterClassFieldAccessor((RawClassSymbol)this.outerClassSymbol, this.classSymbol, true);
        }
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean bl) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !ThisExpression.class.desiredAssertionStatus();
    }
}

