/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.BreakStatement;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CaseStatement;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DefaultStatement;
import oracle.ojc.compiler.EnumMapClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeSymbol;

final class SwitchStatement
extends Statement {
    Expression switchExpr;
    StatementList bodyStatements;
    DefaultStatement defaultStmt;
    CaseStatement[] caseStmts;
    SwitchLoopList switchRec;
    BitSet resultDefSet;
    BitSet resultPosSet;
    BitSet resultUseSet;
    EnumMapClassSymbol emc;

    SwitchStatement(StatementList statementList, int n, Expression expression, StatementList statementList2) {
        super(statementList, n, (byte)4);
        this.switchExpr = expression;
        this.bodyStatements = statementList2;
        statementList2.parent = this;
    }

    private void saveCaseStatementConstants(ArrayList arrayList) {
        arrayList = this.switchRec.caseStmts;
        int n = arrayList.size();
        if (n > 0) {
            CaseStatement[] caseStatementArray;
            int n2;
            if (this.caseStmts != null) {
                n2 = this.caseStmts.length;
                caseStatementArray = new CaseStatement[n2 + n];
                System.arraycopy(this.caseStmts, 0, caseStatementArray, 0, n2);
            } else {
                n2 = 0;
                caseStatementArray = new CaseStatement[n];
            }
            int n3 = n;
            while (--n3 >= 0) {
                caseStatementArray[n2 + n3] = (CaseStatement)arrayList.get(n3);
            }
            this.caseStmts = caseStatementArray;
        } else if (this.caseStmts == null) {
            this.caseStmts = new CaseStatement[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        Expression expression = this.switchExpr;
        expression = expression.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeClass;
        if ((by & 4) == 0) {
            TypeSymbol typeSymbol2;
            if (typeSymbol.isEnum()) {
                this.emc = EnumMapClassSymbol.getEnumMapClass(parser, parser.currentClassSymbol);
            } else if (parser.options.sourceJDKVersion >= 150 && typeSymbol.isReferenceType() && (typeSymbol2 = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null && (typeSymbol2.typeClass & 4) != 0) {
                expression = expression.promoteType(parser, typeSymbol2);
            } else {
                parser.error(Message.errorIncompatibleTypes, expression.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), "int");
            }
        }
        this.switchExpr = expression;
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        this.switchRec = new SwitchLoopList(switchLoopList, this, null, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.switchRec;
            this.bodyStatements.resolveAndCheck(parser);
            Statement statement = this.bodyStatements.last;
            if (statement != null) {
                if (statement.kind == 9) {
                    BreakStatement breakStatement = (BreakStatement)statement;
                    if (breakStatement.labelSymbol == null) {
                        this.bodyStatements.remove(breakStatement);
                    }
                }
                if (!statement.canReachNextStatement(true) && this.resultDefSet != null) {
                    parser.defSet = this.resultDefSet;
                }
            }
            this.saveCaseStatementConstants(this.switchRec.caseStmts);
            this.switchRec.caseStmts = null;
            CaseStatement[] caseStatementArray = this.caseStmts;
            int n = caseStatementArray.length;
            if (n == 0) {
                parser.warning(null, Message.warningSwitchWithoutCase, this.pos);
            } else {
                boolean bl;
                int n2 = 1;
                do {
                    bl = false;
                    for (int i = 0; i < n - n2; ++i) {
                        CaseStatement caseStatement = caseStatementArray[i + 1];
                        CaseStatement caseStatement2 = caseStatementArray[i];
                        int n3 = caseStatement.caseValue;
                        int n4 = caseStatement2.caseValue;
                        if (n3 < n4) {
                            caseStatementArray[i + 1] = caseStatement2;
                            caseStatementArray[i] = caseStatement;
                            bl = true;
                            continue;
                        }
                        if (n3 != n4) continue;
                        parser.error(Message.errorDuplicateCase, caseStatement.pos, false);
                    }
                    ++n2;
                } while (bl);
            }
            this.switchRec.insertLabels();
            if (this.resultDefSet != null) {
                if (this.defaultStmt == null) {
                    parser.defSet = this.switchRec.defSet;
                } else {
                    parser.defSet.and(this.resultDefSet);
                }
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            Object var19_18 = null;
            if (this.switchRec.caseStmts != null) {
                this.saveCaseStatementConstants(this.switchRec.caseStmts);
            }
            parser.innerSwitchLoop = switchLoopList;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (this.switchRec.caseStmts != null) {
                this.saveCaseStatementConstants(this.switchRec.caseStmts);
            }
            parser.innerSwitchLoop = switchLoopList;
            throw throwable;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && this.next.isCodeStatement() && !this.canReachNextStatement(false)) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol classSymbol) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterThrow(parser, classSymbol);
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (labelSymbol != null) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        } else {
            if (!parser.suspendDataFlowChecking) {
                if (this.resultDefSet == null) {
                    this.resultDefSet = (BitSet)parser.defSet.clone();
                } else {
                    this.resultDefSet.and(parser.defSet);
                }
            }
            if (this.resultPosSet == null) {
                this.resultPosSet = (BitSet)parser.posSet.clone();
            } else {
                this.resultPosSet.or(parser.posSet);
            }
            if (this.resultUseSet == null) {
                this.resultUseSet = (BitSet)parser.useSet.clone();
            } else {
                this.resultUseSet.or(parser.useSet);
            }
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.emc != null) {
            RawClassSymbol rawClassSymbol = ((ClassSymbol)this.switchExpr.getType()).getClassSymbol();
            short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(this.emc.getInternalName(), this.emc.getMapName(rawClassSymbol), Identifier.intArraySignature.name);
            byteCodeGenerator.generate_8_16((byte)-78, s);
            byteCodeGenerator.incOpStackHeight(1);
            this.switchExpr.generateByteCode(byteCodeGenerator);
            s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(rawClassSymbol.getInternalName(), Identifier.ordinalIdentifier.name, Identifier.intMethodSignature.name);
            byteCodeGenerator.generate_8_16_8((byte)-74, s, (byte)46);
            byteCodeGenerator.decOpStackHeight(1);
        } else {
            this.switchExpr.generateByteCode(byteCodeGenerator);
        }
        SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.switchRec;
        CaseStatement[] caseStatementArray = this.caseStmts;
        int n = caseStatementArray.length;
        for (int i = 0; i < n; ++i) {
            caseStatementArray[i].label = new Label();
        }
        if (this.defaultStmt != null) {
            this.defaultStmt.label = new Label();
        }
        if (this.switchRec.breakSymbol != null) {
            this.switchRec.breakSymbol.label = new Label();
        }
        if (n == 0) {
            byteCodeGenerator.generate_8((byte)87);
            byteCodeGenerator.decOpStackHeight(1);
            if (this.defaultStmt != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            int n2 = caseStatementArray[0].caseValue;
            int n3 = caseStatementArray[n - 1].caseValue;
            Label label = this.defaultStmt == null ? new Label() : this.defaultStmt.label;
            if (0 < n3 - n2 && n3 - n2 < n + n / 4) {
                short s = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.generate_8((byte)-86);
                byteCodeGenerator.decOpStackHeight(1);
                int n4 = s + 1;
                while ((n4 & 3) != 0) {
                    ++n4;
                    byteCodeGenerator.generate_8((byte)0);
                }
                byteCodeGenerator.generateTableFixup(s, label);
                byteCodeGenerator.generate_32(n2);
                byteCodeGenerator.generate_32(n3);
                int n5 = caseStatementArray[0].caseValue;
                int n6 = 0;
                while (true) {
                    if (n2 != n5) {
                        byteCodeGenerator.generateTableFixup(s, label);
                        ++n2;
                        continue;
                    }
                    byteCodeGenerator.generateTableFixup(s, caseStatementArray[n6].label);
                    if (n2 != n3) {
                        ++n2;
                        n5 = caseStatementArray[++n6].caseValue;
                        continue;
                    }
                    break;
                }
            } else {
                short s = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.generate_8((byte)-85);
                byteCodeGenerator.decOpStackHeight(1);
                int n7 = s + 1;
                while ((n7 & 3) != 0) {
                    ++n7;
                    byteCodeGenerator.generate_8((byte)0);
                }
                byteCodeGenerator.generateTableFixup(s, label);
                byteCodeGenerator.generate_32(n);
                for (int i = 0; i < n; ++i) {
                    CaseStatement caseStatement = caseStatementArray[i];
                    byteCodeGenerator.generate_32(caseStatement.caseValue);
                    byteCodeGenerator.generateTableFixup(s, caseStatement.label);
                }
            }
            this.bodyStatements.generateByteCode(byteCodeGenerator);
            if (this.defaultStmt == null) {
                byteCodeGenerator.setLabel(label);
            }
        }
        byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
    }

    boolean canReachNextStatement(boolean bl) {
        if (this.defaultStmt == null) {
            return true;
        }
        return this.bodyStatements.canReachNextStatement(bl) || this.switchRec.breakSymbol != null && (this.switchRec.breakSymbol.labeledStatement == null || this.switchRec.breakSymbol.labeledStatement.labeledStatements == this.parent);
    }
}

