/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;

final class StatementList {
    Statement parent;
    Statement first;
    Statement last;
    static final /* synthetic */ boolean $assertionsDisabled;

    StatementList() {
    }

    void add(Statement statement) {
        if (this.first == null) {
            this.first = this.last = statement;
        } else {
            this.last.next = statement;
            statement.prev = this.last;
            this.last = statement;
        }
    }

    void remove(Statement statement) {
        if (statement == this.first) {
            this.first = statement.next;
        } else {
            statement.prev.next = statement.next;
        }
        if (statement == this.last) {
            this.last = statement.prev;
        } else {
            statement.next.prev = statement.prev;
        }
    }

    void merge(StatementList statementList) {
        Statement statement;
        while ((statement = statementList.first) != null) {
            statementList.first = statement.next;
            statement.parent = this;
            this.add(statement);
        }
    }

    void resolveAndCheck(Parser parser) {
        Statement statement = this.first;
        while (statement != null) {
            parser.currentStatement = statement;
            ++parser.estimatedLineCount;
            statement.resolveAndCheck(parser);
            statement = statement.next;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled && byteCodeGenerator.getOpStackHeight() != 0) {
            throw new AssertionError();
        }
        boolean bl = byteCodeGenerator.parser.errorFound;
        Statement statement = this.first;
        while (statement != null) {
            Statement statement2;
            if (bl && byteCodeGenerator.parser.errorStatements.containsKey(statement)) {
                Error error = (Error)byteCodeGenerator.parser.errorStatements.get(statement);
                ErrorExpression errorExpression = new ErrorExpression(error);
                statement2 = new ExpressionStatement(statement.parent, statement.pos, errorExpression);
            } else {
                statement2 = statement;
            }
            byteCodeGenerator.parser.currentStatement = statement2;
            if (statement2.pos != 0) {
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(statement2.pos));
            }
            statement2.generateByteCode(byteCodeGenerator);
            if (!$assertionsDisabled && byteCodeGenerator.getOpStackHeight() != 0) {
                throw new AssertionError();
            }
            statement = statement.next;
        }
        byteCodeGenerator.parser.currentStatement = null;
    }

    boolean isLoopExitStatement() {
        if (this.last != null) {
            return this.last.isLoopExitStatement();
        }
        return false;
    }

    boolean canReachNextStatement(boolean bl) {
        if (this.last != null) {
            return this.last.canReachNextStatement(bl);
        }
        return true;
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterReturn(parser);
        }
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol classSymbol) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterThrow(parser, classSymbol);
        }
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
        }
    }

    static {
        $assertionsDisabled = !StatementList.class.desiredAssertionStatus();
    }
}

