/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;

abstract class Statement {
    static final byte SK_EMPTY = 0;
    static final byte SK_EXPRESSION = 1;
    static final byte SK_IF = 2;
    static final byte SK_IF_ELSE = 3;
    static final byte SK_SWITCH = 4;
    static final byte SK_CASE = 5;
    static final byte SK_DEFAULT = 6;
    static final byte SK_LABEL = 7;
    static final byte SK_LABELED = 8;
    static final byte SK_BREAK = 9;
    static final byte SK_CONTINUE = 10;
    static final byte SK_FOR = 11;
    static final byte SK_WHILE = 12;
    static final byte SK_DO = 13;
    static final byte SK_RETURN = 14;
    static final byte SK_SYNCHRONIZED = 15;
    static final byte SK_THROW = 16;
    static final byte SK_TRY = 17;
    static final byte SK_ASSERT = 18;
    static final byte SK_FIELDINITIALIZATION = 19;
    static final byte SK_DYNAMICINITIALIZATION = 20;
    static final byte SK_ENDOFSCOPE = 21;
    byte kind;
    int pos;
    StatementList parent;
    Statement next;
    Statement prev;

    Statement(StatementList statementList, int n, byte by) {
        this.parent = statementList;
        this.pos = n;
        this.kind = by;
    }

    void insertBefore(Statement statement) {
        Statement statement2;
        statement.prev = statement2 = this.prev;
        statement.next = this;
        if (statement2 != null) {
            statement2.next = statement;
        } else {
            this.parent.first = statement;
        }
        this.prev = statement;
    }

    void insertAfter(Statement statement) {
        Statement statement2;
        statement.next = statement2 = this.next;
        statement.prev = this;
        if (statement2 != null) {
            statement2.prev = statement;
        } else {
            this.parent.last = statement;
        }
        this.next = statement;
    }

    abstract void resolveAndCheck(Parser var1);

    abstract void generateByteCode(ByteCodeGenerator var1);

    boolean isCodeStatement() {
        return true;
    }

    boolean isLoopExitStatement() {
        return false;
    }

    boolean canReachNextStatement(boolean bl) {
        return true;
    }

    void setLastStatement() {
        if (this.parent.parent == null || this.parent.parent.kind != 4) {
            this.parent.last = this;
        }
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol classSymbol) {
        this.parent.updateDefUseSetsAfterThrow(parser, classSymbol);
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
    }
}

