/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CodeCoachPragma;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedStaticImportList;
import oracle.ojc.compiler.UnresolvedSuperClassException;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;

final class SourceFile {
    SourceFile next;
    Storage storage;
    String canonicalPath;
    File preprocessorFile;
    ArrayList messageList;
    PackageScope packageScope;
    ImportDescriptor importList;
    Symbol[] importDeclarations;
    UnresolvedStaticImportList usil;
    boolean deprecatedWarningFound;
    short codeCoachPragmaCount;
    CodeCoachPragma codeCoachPragmaList;
    private CodeCoachPragma codeCoachPragmaLast;

    SourceFile(Storage storage) {
        this.storage = storage;
        this.messageList = new ArrayList();
    }

    String getName() {
        if (this.preprocessorFile != null) {
            return this.preprocessorFile.getName();
        }
        return this.storage.getName();
    }

    String getPath() {
        if (this.preprocessorFile != null) {
            return this.preprocessorFile.getPath();
        }
        return this.storage.getPath();
    }

    String getCanonicalPath() {
        if (this.canonicalPath == null) {
            if (this.preprocessorFile != null) {
                try {
                    this.canonicalPath = this.preprocessorFile.getCanonicalPath();
                }
                catch (IOException iOException) {}
            } else {
                this.canonicalPath = this.storage.getCanonicalPath();
            }
        }
        return this.canonicalPath;
    }

    void addCodecoachPragma(Parser parser, int n, byte by, Identifier identifier) {
        if (parser.options.codecoach) {
            CodeCoachPragma codeCoachPragma = new CodeCoachPragma(n, by, identifier);
            if (this.codeCoachPragmaList == null) {
                this.codeCoachPragmaList = this.codeCoachPragmaLast = codeCoachPragma;
            } else {
                this.codeCoachPragmaLast.next = codeCoachPragma;
                this.codeCoachPragmaLast = codeCoachPragma;
            }
            this.codeCoachPragmaCount = (short)(this.codeCoachPragmaCount + 1);
        }
    }

    private void addImportSymbol(Parser parser, ImportDescriptor importDescriptor, Symbol symbol, boolean bl) {
        ImportSymbol importSymbol = parser.currentPackageScope.lookupImportSymbol(symbol.identifier, symbol.kind);
        if (importSymbol != null) {
            if (importSymbol.importedSymbol == symbol) {
                if (importDescriptor.pos != importSymbol.pos) {
                    parser.warning(null, Message.warningDuplicateImport, importDescriptor.pos, symbol.errorName());
                }
                return;
            }
            if ((importSymbol.flags & 4) == 0 && !bl) {
                if (symbol.kind != 8) {
                    parser.error(Message.errorDoubleImport, importDescriptor.pos, false, symbol.errorName());
                    return;
                }
            } else if (importSymbol.importedSymbol.kind == 2 && symbol.kind == 2 && importDescriptor.importSymbolList.contains(importSymbol)) {
                return;
            }
        }
        importSymbol = new ImportSymbol(importDescriptor.pos, symbol, importDescriptor);
        importSymbol.flags = !bl ? (byte)(importSymbol.flags | 3) : (symbol.kind == 32 && ((ClassSymbol)symbol).isInnerClass() ? (byte)(importSymbol.flags | 0xB) : (byte)(importSymbol.flags | 7));
        importDescriptor.importSymbolList.add(importSymbol);
        this.packageScope.enterSymbol(importSymbol);
    }

    private static boolean isImportable(Parser parser, Scope scope, RawClassSymbol rawClassSymbol, short s) {
        if ((s & 8) == 0) {
            return false;
        }
        if ((s & 1) == 0) {
            return scope == parser.currentPackageScope;
        }
        if (rawClassSymbol != null) {
            while (true) {
                if ((rawClassSymbol.access & 1) == 0) {
                    return scope == parser.currentPackageScope;
                }
                if (!rawClassSymbol.isInnerClass()) break;
                rawClassSymbol = rawClassSymbol.getOuterClass();
            }
        }
        return true;
    }

    private boolean importStaticSymbol(Parser parser, UnresolvedStaticImportList unresolvedStaticImportList, ClassSymbol classSymbol) {
        FieldSymbol fieldSymbol;
        MethodSymbol methodSymbol;
        if (classSymbol instanceof UnresolvedClassSymbol) {
            throw new UnresolvedSuperClassException(classSymbol);
        }
        boolean bl = false;
        RawClassSymbol rawClassSymbol = classSymbol.getClassSymbol();
        Scope scope = rawClassSymbol.getPackageScope();
        if (unresolvedStaticImportList.identifier == null) {
            bl = true;
            methodSymbol = rawClassSymbol.cd.methodList;
            while (methodSymbol != null) {
                if (SourceFile.isImportable(parser, scope, rawClassSymbol, methodSymbol.access) && !methodSymbol.isSynthetic() && !methodSymbol.isGenerated() && !methodSymbol.isClassInitializer()) {
                    this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, methodSymbol, true);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
            fieldSymbol = rawClassSymbol.cd.fieldList;
            while (fieldSymbol != null) {
                if (SourceFile.isImportable(parser, scope, rawClassSymbol, fieldSymbol.access) && !fieldSymbol.isSynthetic()) {
                    this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, fieldSymbol, true);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
            TypeSymbolList typeSymbolList = rawClassSymbol.cd.innerClassList;
            while (typeSymbolList != null) {
                TypeSymbol typeSymbol = typeSymbolList.typeSymbol;
                if ((typeSymbol.isStaticInnerClass() || typeSymbol.isInterface()) && ((typeSymbol.access & 1) != 0 || scope == parser.currentPackageScope)) {
                    this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, typeSymbolList.typeSymbol, true);
                }
                typeSymbolList = typeSymbolList.next;
            }
        } else {
            TypeSymbol typeSymbol;
            Symbol symbol = rawClassSymbol.classScope.lookupSpecificSymbolInScope(unresolvedStaticImportList.identifier, 2, true);
            if (symbol != null) {
                fieldSymbol = (FieldSymbol)symbol;
                if (SourceFile.isImportable(parser, scope, rawClassSymbol, fieldSymbol.access)) {
                    bl = true;
                    this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, fieldSymbol, false);
                }
            }
            if ((symbol = rawClassSymbol.classScope.lookupSpecificSymbolInScope(unresolvedStaticImportList.identifier, 8, true)) != null) {
                methodSymbol = (MethodSymbol)symbol;
                symbol = null;
                while (methodSymbol != null) {
                    if (SourceFile.isImportable(parser, scope, rawClassSymbol, methodSymbol.access)) {
                        bl = true;
                        this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, methodSymbol, false);
                    }
                    methodSymbol = methodSymbol.nextWithSameName;
                }
            }
            if ((symbol = rawClassSymbol.classScope.lookupSpecificSymbolInScope(unresolvedStaticImportList.identifier, 32, true)) != null && (((typeSymbol = (TypeSymbol)symbol).isStaticInnerClass() || typeSymbol.isInterface()) && (typeSymbol.access & 1) != 0 || scope == parser.currentPackageScope)) {
                bl = true;
                this.addImportSymbol(parser, unresolvedStaticImportList.importDesc, typeSymbol, false);
            }
        }
        ImplementationList implementationList = classSymbol.getImplementationList();
        while (implementationList != null) {
            bl |= this.importStaticSymbol(parser, unresolvedStaticImportList, implementationList.interfaceSymbol);
            implementationList = implementationList.next;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resolveStaticImports(Parser parser) {
        parser.currentPackageScope.enterDeclarations(parser.sourceFile.importDeclarations);
        ArrayList arrayList = new ArrayList();
        parser.currentPackageScope.recordDeclarations(arrayList);
        try {
            UnresolvedStaticImportList unresolvedStaticImportList = this.usil;
            while (unresolvedStaticImportList != null) {
                if (unresolvedStaticImportList.unresolvedClass.qualifierList == null) {
                    parser.error(Message.errorNotFound, unresolvedStaticImportList.importDesc.pos, false, unresolvedStaticImportList.unresolvedClass.toString(), "");
                } else {
                    TypeSymbol typeSymbol = unresolvedStaticImportList.unresolvedClass.resolveType(parser, unresolvedStaticImportList.importDesc.pos, true, true, false);
                    if (!typeSymbol.isErroneous()) {
                        if (!typeSymbol.toString().equals(unresolvedStaticImportList.unresolvedClass.toString())) {
                            parser.error(Message.errorNonCanonicalImport, unresolvedStaticImportList.importDesc.pos, false, unresolvedStaticImportList.unresolvedClass.toString());
                        } else {
                            boolean bl = false;
                            for (ClassSymbol classSymbol = (ClassSymbol)typeSymbol; classSymbol != null; bl |= this.importStaticSymbol(parser, unresolvedStaticImportList, classSymbol), classSymbol = classSymbol.getSuperClassSymbol()) {
                            }
                            if (!bl) {
                                parser.error(Message.errorNotFound, unresolvedStaticImportList.importDesc.pos, typeSymbol.isErroneous(), Message.memberString + " " + unresolvedStaticImportList.identifier.toString(), Message.inString + " " + typeSymbol.errorName());
                            }
                        }
                    }
                }
                unresolvedStaticImportList = unresolvedStaticImportList.next;
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            parser.currentPackageScope.recordDeclarations(null);
            int n = arrayList.size();
            if (n <= 0) {
                parser.currentPackageScope.removeDeclarations(parser.sourceFile.importDeclarations);
                throw throwable;
            }
            int n2 = 0;
            if (parser.sourceFile.importDeclarations != null) {
                n2 = parser.sourceFile.importDeclarations.length;
            }
            Symbol[] symbolArray = arrayList.toArray(new Symbol[n + n2]);
            if (n2 > 0) {
                System.arraycopy(parser.sourceFile.importDeclarations, 0, symbolArray, n, n2);
            }
            parser.currentPackageScope.removeDeclarations(symbolArray);
            parser.sourceFile.importDeclarations = symbolArray;
            throw throwable;
        }
        parser.currentPackageScope.recordDeclarations(null);
        int n = arrayList.size();
        if (n > 0) {
            int n3 = 0;
            if (parser.sourceFile.importDeclarations != null) {
                n3 = parser.sourceFile.importDeclarations.length;
            }
            Symbol[] symbolArray = arrayList.toArray(new Symbol[n + n3]);
            if (n3 > 0) {
                System.arraycopy(parser.sourceFile.importDeclarations, 0, symbolArray, n, n3);
            }
            parser.currentPackageScope.removeDeclarations(symbolArray);
            parser.sourceFile.importDeclarations = symbolArray;
        } else {
            parser.currentPackageScope.removeDeclarations(parser.sourceFile.importDeclarations);
        }
        this.usil = null;
    }

    boolean printMessages(Parser parser, Log log) {
        int n = this.messageList.size();
        if (n == 0) {
            return true;
        }
        Message[] messageArray = this.messageList.toArray(new Message[n]);
        this.messageList = null;
        int n2 = n;
        while (--n2 >= 0) {
            for (int i = 0; i < n2; ++i) {
                Message message = messageArray[i];
                Message message2 = messageArray[i + 1];
                if (message.pos <= message2.pos) continue;
                messageArray[i] = message2;
                messageArray[i + 1] = message;
            }
        }
        Message message = new Error(null, Message.errorCannotCopy, 0);
        for (n2 = 0; n2 < n; ++n2) {
            Message message3 = messageArray[n2];
            if (message3.pos != message.pos || message3.message.getNumber() != message.message.getNumber() || !message3.message.getMessage().equals(message.message.getMessage())) {
                if (message3 instanceof Error) {
                    log.printError(this.storage, message3.pos, message3.message);
                    ++parser.errorCount;
                } else if (!parser.errorFound || parser.options.warningsAreErrors) {
                    log.printWarning(this.storage, message3.pos, message3.message);
                    ++parser.warningCount;
                }
                if (parser.errorCount + parser.warningCount >= parser.options.messageLimit || parser.errorCount >= parser.options.errorLimit || parser.warningCount >= parser.options.warningLimit) {
                    log.println(Message.errorColonString + Message.tooManyErrorsAndWarningsString);
                    return false;
                }
            }
            message = message3;
        }
        return true;
    }
}

