/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.interfaces.Storage;

final class PackageSymbol
extends Symbol {
    PackageScope packageScope;
    Storage[] classStorage;
    Storage[] sourceStorage;
    char[] signature;

    PackageSymbol(int n, Identifier identifier, PackageScope packageScope) {
        super((byte)16, n, identifier);
        this.packageScope = packageScope;
        packageScope.parser.options.findClassStorageForPackage(this);
        packageScope.parser.options.findSourceStorageForPackage(this);
    }

    String kindName() {
        return Message.packageString;
    }

    char[] getSignature() {
        if (this.signature == null) {
            char[] cArray = null;
            int n = this.identifier.name.length;
            StorageScope storageScope = this.packageScope.outerScope;
            if (storageScope.kind == 1) {
                PackageScope packageScope = (PackageScope)storageScope;
                PackageSymbol packageSymbol = packageScope.packageSymbol;
                if (packageSymbol != null) {
                    cArray = packageSymbol.getSignature();
                    n += cArray.length + 1;
                }
            }
            this.signature = new char[n];
            int n2 = 0;
            if (cArray != null) {
                System.arraycopy(cArray, 0, this.signature, 0, cArray.length);
                n2 = cArray.length;
                this.signature[n2++] = 47;
            }
            System.arraycopy(this.identifier.name, 0, this.signature, n2, this.identifier.name.length);
        }
        return this.signature;
    }

    protected void toString(StringBuffer stringBuffer) {
        StorageScope storageScope = this.packageScope.outerScope;
        if (storageScope.kind == 1) {
            PackageScope packageScope = (PackageScope)storageScope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            if (packageSymbol != null) {
                packageSymbol.toString(stringBuffer);
                stringBuffer.append('.');
            }
        }
        stringBuffer.append(this.identifier.name);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    byte getAnnotationTarget() {
        return -128;
    }

    PackageSymbol getOuterPackage() {
        StorageScope storageScope = this.packageScope.outerScope;
        if (storageScope.kind == 1) {
            PackageScope packageScope = (PackageScope)storageScope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            return packageSymbol;
        }
        return null;
    }

    static PackageSymbol getPackageSymbol(Parser parser, String string) {
        PackageSymbol packageSymbol;
        int n = string.length();
        StorageScope storageScope = parser.globalScope;
        int n2 = 0;
        while (true) {
            PackageScope packageScope;
            Identifier identifier;
            int n3;
            if ((n3 = string.indexOf(46, n2)) < 0) {
                n3 = n;
            }
            if ((packageSymbol = (PackageSymbol)storageScope.lookupSpecificSymbolInScope(identifier = Identifier.getIdentifier(string.substring(n2, n3)), 16, false)) != null) {
                packageScope = packageSymbol.packageScope;
            } else {
                packageScope = new PackageScope(parser, storageScope);
                packageSymbol = new PackageSymbol(0, identifier, packageScope);
                storageScope.enterSymbol(packageSymbol);
                packageScope.packageSymbol = packageSymbol;
                packageScope.readPackage();
            }
            if (n3 == n) break;
            storageScope = packageScope;
            n2 = n3 + 1;
        }
        return packageSymbol;
    }
}

