/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;

final class NewExpression
extends Expression {
    static final byte[] newArrayKind = new byte[12];
    ExpressionList dimExprList;
    Expression outerClassExpression;
    TypeSymbol newType;
    int dimension;

    NewExpression(int n, TypeSymbol typeSymbol, Expression expression, ExpressionList expressionList) {
        super((byte)47, n);
        this.newType = typeSymbol;
        this.outerClassExpression = expression;
        this.dimExprList = expressionList;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        TypeSymbol typeSymbol2;
        UnresolvedClassSymbol unresolvedClassSymbol;
        if (this.outerClassExpression != null) {
            this.outerClassExpression = this.outerClassExpression.resolveAndCheck(parser);
            TypeSymbol typeSymbol3 = this.outerClassExpression.getType();
            if (!typeSymbol3.isClass()) {
                Error error = parser.error(Message.errorObjectRequired, this.outerClassExpression.pos, typeSymbol3.isErroneous(), typeSymbol3.errorName());
                return new ErrorExpression(error);
            }
            if (this.newType instanceof UnresolvedClassSymbol) {
                unresolvedClassSymbol = (UnresolvedClassSymbol)this.newType;
                unresolvedClassSymbol.scope = ((ClassSymbol)typeSymbol3).getClassScope();
                if (unresolvedClassSymbol.qualifierList != null) {
                    parser.error(Message.errorIllegalQualifier, this.pos, false, "new");
                }
            }
        }
        if (this.newType.isAnonymousInnerClass()) {
            typeSymbol2 = this.newType;
        } else {
            this.newType = typeSymbol2 = this.newType.resolveType(parser, this.pos, false, true, false);
        }
        if (typeSymbol2.isPrimitiveType()) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.pos, typeSymbol2.isErroneous(), Message.classString, typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        typeSymbol2.checkDeprecated(parser, this.pos);
        if (typeSymbol2.isArrayType()) {
            ExpressionList expressionList = this.dimExprList;
            expressionList = this.dimExprList;
            int n = 0;
            while (expressionList != null) {
                Expression expression = expressionList.expr;
                expression = expression.resolveAndCheck(parser);
                TypeSymbol typeSymbol4 = expression.getType();
                if ((typeSymbol4.typeClass & 4) == 0) {
                    TypeSymbol typeSymbol5;
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol4.isReferenceType() && (typeSymbol5 = BoxingExpression.getPrimitiveType(parser, typeSymbol4)) != null && (typeSymbol5.typeClass & 4) != 0) {
                        expression = new AutoUnboxingExpression(expression, typeSymbol5);
                        typeSymbol4 = typeSymbol5;
                    } else {
                        Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, typeSymbol4.isErroneous(), typeSymbol4.errorName(), "int");
                        return new ErrorExpression(error);
                    }
                }
                typeSymbol4 = TypeSymbol.unaryNumericPromotion(parser, typeSymbol4);
                expressionList.expr = expression.promoteType(parser, typeSymbol4);
                expressionList = expressionList.next;
                ++n;
            }
            this.dimension = n;
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol2;
            if (arraySymbol.baseType.isParameterizedClass() && !arraySymbol.baseType.isReifiable()) {
                Error error = parser.error(Error.errorGenericsInArrayCreation, this.pos, false);
                return new ErrorExpression(error);
            }
        } else if (this.outerClassExpression != null) {
            ParameterizedClassSymbol parameterizedClassSymbol;
            RawClassSymbol rawClassSymbol;
            AnonymousClassSymbol anonymousClassSymbol = null;
            Identifier identifier = typeSymbol2.identifier;
            if (typeSymbol2.isAnonymousInnerClass()) {
                anonymousClassSymbol = (AnonymousClassSymbol)typeSymbol2;
                ClassSymbol classSymbol = anonymousClassSymbol.superClass;
                identifier = classSymbol.identifier;
                if (classSymbol instanceof UnresolvedClassSymbol) {
                    unresolvedClassSymbol = (UnresolvedClassSymbol)classSymbol;
                    if (unresolvedClassSymbol.qualifierList != null) {
                        Error error = parser.error(Message.errorIllegalQualifier, this.pos, false, "new");
                        if (anonymousClassSymbol != null) {
                            anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x10);
                        }
                        return new ErrorExpression(error);
                    }
                }
            }
            if ((typeSymbol = this.outerClassExpression.getType()).isRawClass()) {
                typeSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol, null, null);
            }
            if ((rawClassSymbol = (parameterizedClassSymbol = (ParameterizedClassSymbol)typeSymbol).getClassSymbol().lookupInnerClassByName(identifier)) == null || (rawClassSymbol.access & 8) != 0) {
                Error error = parser.error(Message.errorNotFound, this.pos, typeSymbol2.isErroneous(), typeSymbol2.errorName(), Message.inString + " " + parameterizedClassSymbol.errorName());
                if (anonymousClassSymbol != null) {
                    anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            parser.addAmbiguityCheck(parameterizedClassSymbol.getClassSymbol(), rawClassSymbol);
            if (!rawClassSymbol.isAccessible(parser.currentClassSymbol) || rawClassSymbol.getTopLevelClass() != parser.currentClassSymbol.getTopLevelClass() && (rawClassSymbol.access & 2) != 0) {
                Error error = parser.error(Message.errorAccessError, this.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName(), (rawClassSymbol.access & 2) != 0 ? "private" : "protected", Message.inString + " " + parser.currentClassSymbol.errorName());
                if (anonymousClassSymbol != null) {
                    anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            if ((rawClassSymbol.access & 0x400) != 0) {
                Error error = parser.error(Message.errorAbstractInstantiation, this.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName());
                if (anonymousClassSymbol != null) {
                    anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            if (anonymousClassSymbol != null) {
                unresolvedClassSymbol = (UnresolvedClassSymbol)anonymousClassSymbol.superClass;
                unresolvedClassSymbol.resolveActualTypeParameters(parser, this.pos, false);
                ParameterizedClassSymbol parameterizedClassSymbol2 = ParameterizedClassSymbol.getParameterizedClassSymbol(rawClassSymbol, unresolvedClassSymbol.typeVariableList, parameterizedClassSymbol);
                parameterizedClassSymbol2.checkActualTypeParameters(parser, this.pos);
                anonymousClassSymbol.superClass = parameterizedClassSymbol2;
                anonymousClassSymbol.completeAnonymousClass(parser);
            } else {
                ParameterizedClassSymbol parameterizedClassSymbol3 = (ParameterizedClassSymbol)typeSymbol2;
                this.newType = typeSymbol2 = ParameterizedClassSymbol.getParameterizedClassSymbol(parameterizedClassSymbol3.genericClassSymbol, parameterizedClassSymbol3.typeVariableList, parameterizedClassSymbol);
            }
        } else {
            ClassSymbol classSymbol;
            AnonymousClassSymbol anonymousClassSymbol;
            RawClassSymbol rawClassSymbol = ((ClassSymbol)typeSymbol2).getClassSymbol();
            if (rawClassSymbol.isAnonymousInnerClass()) {
                anonymousClassSymbol = (AnonymousClassSymbol)rawClassSymbol;
                if ((anonymousClassSymbol.flags & 0x10) != 0) {
                    return ErrorExpression.errorExpression;
                }
                anonymousClassSymbol.completeAnonymousClass(parser);
                anonymousClassSymbol.superClass = classSymbol = (ClassSymbol)anonymousClassSymbol.superClass.resolveType(parser, this.pos, true, true, false);
                if (classSymbol.isNonStaticInnerClass() && (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0)) {
                    Error error = parser.error(Message.errorUndefinedThis, this.pos, classSymbol.isErroneous(), classSymbol.errorName());
                    anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x10);
                    return new ErrorExpression(error);
                }
            }
            if ((rawClassSymbol.access & 0x400) != 0) {
                Error error = parser.error(Message.errorAbstractInstantiation, this.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName());
                return new ErrorExpression(error);
            }
            if (rawClassSymbol.isNonStaticInnerClass()) {
                if (rawClassSymbol.isAnonymousInnerClass()) {
                    anonymousClassSymbol = (AnonymousClassSymbol)rawClassSymbol;
                    classSymbol = anonymousClassSymbol.superClass;
                    if (classSymbol.isInnerClass() && !classSymbol.isLocalInnerClass()) {
                        parser.addAmbiguityCheck(classSymbol.getOuterClass(), classSymbol.getClassSymbol());
                    }
                } else if (!rawClassSymbol.isLocalInnerClass()) {
                    parser.addAmbiguityCheck(rawClassSymbol.getOuterClass(), rawClassSymbol);
                }
                if (!((parser.currentClassSymbol.access & 8) == 0 || rawClassSymbol.getTopLevelClass() != parser.currentClassSymbol.getTopLevelClass() || rawClassSymbol.isInnerClass(parser.currentClassSymbol) || parser.currentClassSymbol.equalTo(rawClassSymbol) || parser.currentClassSymbol.isSuperclass(rawClassSymbol) || rawClassSymbol.getOuterClass().equalTo(parser.currentClassSymbol) || rawClassSymbol.getOuterClass().isSuperclass(parser.currentClassSymbol))) {
                    Error error = parser.error(Message.errorUndefinedThis, this.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if ((parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) && (!parser.currentClassSymbol.isInnerClass() || (parser.currentClassSymbol.access & 8) != 0 && !parser.currentClassSymbol.equalTo(rawClassSymbol) && !parser.currentClassSymbol.isSuperclass(rawClassSymbol))) {
                    Error error = parser.error(Message.errorUndefinedThis, this.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName());
                    return new ErrorExpression(error);
                }
            }
        }
        if ((typeSymbol = typeSymbol2).isArrayType()) {
            typeSymbol = ((ArraySymbol)typeSymbol).baseType;
        }
        if (typeSymbol.isTypeParameter()) {
            Error error = parser.error(Message.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
            return new ErrorExpression(error);
        }
        this.setType(typeSymbol2);
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        RawClassSymbol rawClassSymbol = byteCodeGenerator.parser.currentClassSymbol;
        TypeSymbol typeSymbol = this.newType;
        if (typeSymbol.isArrayType()) {
            TypeSymbol typeSymbol2;
            ExpressionList expressionList = this.dimExprList;
            int n = this.dimension;
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            if (n == 1) {
                expressionList.expr.generateByteCode(byteCodeGenerator);
                typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                if (typeSymbol2.isPrimitiveType()) {
                    byteCodeGenerator.generate_8_8((byte)-68, newArrayKind[typeSymbol2.typeKind]);
                } else {
                    short s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol2.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-67, s);
                }
            } else {
                while (expressionList != null) {
                    expressionList.expr.generateByteCode(byteCodeGenerator);
                    expressionList = expressionList.next;
                }
                short s = byteCodeGenerator.constantPool.enterConstantPoolClass(arraySymbol.getInternalName());
                byteCodeGenerator.generate_8_16_8((byte)-59, s, (byte)n);
                byteCodeGenerator.decOpStackHeight(n - 1);
            }
            if (this.getType().typeKind == 1) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if ((typeSymbol2 = arraySymbol.baseType).isClass()) {
                RawClassSymbol rawClassSymbol2 = ((ClassSymbol)typeSymbol2).getClassSymbol();
                byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, rawClassSymbol2);
            }
        } else {
            short s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            byteCodeGenerator.generate_8_16_8((byte)-69, s, (byte)89);
            byteCodeGenerator.incOpStackHeight(2);
            if (typeSymbol.isAnonymousInnerClass() && ((AnonymousClassSymbol)typeSymbol).hasHiddenOuterThisArgument()) {
                byteCodeGenerator.generate_8((byte)42);
                byteCodeGenerator.incOpStackHeight(1);
            }
            if (this.outerClassExpression != null) {
                this.outerClassExpression.generateByteCode(byteCodeGenerator);
                if (!(this.outerClassExpression instanceof ThisExpression) || ((ThisExpression)this.outerClassExpression).outerClassSymbol != null) {
                    s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangObjectInternal.name, Identifier.getClassIdentifier.name, Identifier.javaLangClassMethodSignature.name);
                    byteCodeGenerator.generate_8((byte)89);
                    byteCodeGenerator.generate_8_16_8((byte)-74, s, (byte)87);
                    byteCodeGenerator.incOpStackHeight(1);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            } else {
                RawClassSymbol rawClassSymbol3 = ((ClassSymbol)typeSymbol).getClassSymbol();
                if (rawClassSymbol3.isAnonymousInnerClass()) {
                    rawClassSymbol3 = rawClassSymbol3.getSuperClassSymbol().getClassSymbol();
                }
                if (rawClassSymbol3.isNonStaticInnerClass()) {
                    rawClassSymbol3 = rawClassSymbol3.getOuterClass();
                    if (rawClassSymbol.isInnerClass() && !rawClassSymbol3.equalTo(rawClassSymbol) && !rawClassSymbol3.isInnerClass(rawClassSymbol) && !rawClassSymbol3.isSuperclass(rawClassSymbol)) {
                        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor()) {
                            byteCodeGenerator.loadLocalVariable(rawClassSymbol3, (short)0);
                        }
                        byteCodeGenerator.generateOuterClassFieldAccessor(rawClassSymbol3, rawClassSymbol, false);
                    } else {
                        byteCodeGenerator.loadLocalVariable(rawClassSymbol3, (short)0);
                    }
                }
            }
            RawClassSymbol rawClassSymbol4 = ((ClassSymbol)typeSymbol).getClassSymbol();
            byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, rawClassSymbol4);
        }
    }

    public String toString() {
        return "new";
    }

    static {
        NewExpression.newArrayKind[2] = 4;
        NewExpression.newArrayKind[4] = 5;
        NewExpression.newArrayKind[8] = 6;
        NewExpression.newArrayKind[9] = 7;
        NewExpression.newArrayKind[3] = 8;
        NewExpression.newArrayKind[5] = 9;
        NewExpression.newArrayKind[6] = 10;
        NewExpression.newArrayKind[7] = 11;
    }
}

