/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.VariableExpression;

final class MethodVariableExpression
extends VariableExpression {
    MethodVariableSymbol variable;

    MethodVariableExpression(int n, MethodVariableSymbol methodVariableSymbol) {
        super(n);
        this.variable = methodVariableSymbol;
    }

    short getAccess() {
        return this.variable.access;
    }

    String errorName() {
        return this.variable.errorName();
    }

    Expression resolveAndCheck(Parser parser) {
        int n = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking && !parser.defSet.get(n)) {
            parser.error(Message.errorNotInitialized, this.pos, false, this.variable.errorName());
            parser.defSet.set(n);
            parser.posSet.set(n);
        }
        parser.useSet.set(n);
        TypeSymbol typeSymbol = this.variable.type.resolveType(parser, this.pos, false, true, false);
        this.setType(typeSymbol);
        if (this.variable instanceof LocalVariableSymbol) {
            LocalVariableSymbol localVariableSymbol = (LocalVariableSymbol)this.variable;
            if (localVariableSymbol.initializer != null && localVariableSymbol.initializer.kind == 2) {
                Expression expression = localVariableSymbol.initializer;
                switch (expression.getType().typeKind) {
                    default: {
                        return CastExpression.castNumericConstant(expression, typeSymbol, true);
                    }
                    case 2: {
                        return new BooleanConstantExpression(expression.pos, ((BooleanConstantExpression)expression).bval);
                    }
                    case 10: 
                }
                if (expression instanceof StringConstantExpression) {
                    StringConstantExpression stringConstantExpression = (StringConstantExpression)expression;
                    return new StringConstantExpression(expression.pos, stringConstantExpression.getType(), stringConstantExpression.sval);
                }
            }
        }
        return this;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        int n = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking) {
            if (!parser.defSet.get(n)) {
                parser.error(Message.errorNotInitialized, this.pos, false, this.variable.errorName());
            } else if ((this.getAccess() & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
            this.variable.pos = this.pos;
            parser.defSet.set(n);
            parser.posSet.set(n);
        }
        if (parser.innerSwitchLoop == null || !parser.innerSwitchLoop.inLoop()) {
            parser.useSet.clear(n);
        } else {
            parser.useSet.set(n);
        }
        TypeSymbol typeSymbol = this.variable.type;
        this.setType(typeSymbol);
        return this;
    }

    Expression resolveAndCheckWrite(Parser parser) {
        TypeSymbol typeSymbol = this.variable.type;
        this.setType(typeSymbol);
        return this;
    }

    void markDefined(Parser parser) {
        boolean bl = false;
        int n = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking) {
            if ((this.getAccess() & 0x10) != 0) {
                if (parser.defSet.get(n)) {
                    parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
                } else if (parser.posSet.get(n)) {
                    parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                } else {
                    if (parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop()) {
                        LoopStatement loopStatement = parser.innerSwitchLoop.getLoopStatement();
                        if (parser.currentStatement == loopStatement) {
                            if (!loopStatement.bodyStatements.last.isLoopExitStatement()) {
                                parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                            }
                        } else if (this.variable.pos < loopStatement.bodyPos && !parser.currentStatement.parent.last.isLoopExitStatement()) {
                            loopStatement.possibleReinitialization(this.pos, this.variable);
                        }
                    }
                    if ((this.variable.flags & 1) != 0) {
                        bl = true;
                        parser.useSet.set(n);
                        parser.currentClassSymbol.checkSyntheticFieldsInInnerClass(parser, this.variable, this.pos);
                    }
                }
            }
        } else if ((this.getAccess() & 0x10) != 0 && !parser.defSet.get(n) && parser.posSet.get(n)) {
            parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
        }
        this.variable.pos = this.pos;
        parser.defSet.set(n);
        parser.posSet.set(n);
        if (!(parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop() || bl)) {
            parser.useSet.clear(n);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.loadLocalVariable(this.getType(), this.variable.varStackIndex);
        int n = byteCodeGenerator.generateGetPC() & 0xFFFF;
        if (n < (this.variable.startPC & 0xFFFF)) {
            this.variable.startPC = (short)n;
        }
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean bl) {
        this.generateByteCode(byteCodeGenerator);
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.storeLocalVariable(this.getType(), this.variable.varStackIndex);
        int n = byteCodeGenerator.generateGetPC() & 0xFFFF;
        if (n < (this.variable.startPC & 0xFFFF)) {
            this.variable.startPC = (short)n;
        }
    }
}

