/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class LongConstantExpression
extends ConstantExpression {
    long lval;

    LongConstantExpression(int n, long l) {
        super(n, TypeSymbol.longSymbol);
        this.lval = l;
    }

    Expression copyConstantExpression() {
        return new LongConstantExpression(this.pos, this.lval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        long l = this.lval;
        if (l < -128L || 127L < l) {
            short s = byteCodeGenerator.constantPool.enterConstantPoolLong(l);
            byteCodeGenerator.generate_8_16((byte)20, s);
        } else {
            switch ((int)l) {
                default: {
                    byteCodeGenerator.generate_8_8_8((byte)16, (byte)l, (byte)-123);
                    break;
                }
                case 0: 
                case 1: {
                    byteCodeGenerator.generate_8((byte)(9L + l));
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byteCodeGenerator.generate_8_8((byte)(3L + l), (byte)-123);
                }
            }
        }
        byteCodeGenerator.incOpStackHeight(2);
    }
}

