/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.AssignmentExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DynamicInitializationStatement;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;

class InnerClassSymbol
extends RawClassSymbol {
    HiddenArgumentList hiddenArgumentList;
    short hiddenArgCount;

    InnerClassSymbol(int n, Identifier identifier, short s, TypeParameterList typeParameterList, Annotation annotation, boolean bl) {
        super(n, identifier, s, typeParameterList, annotation, bl, false);
    }

    protected void toString(StringBuffer stringBuffer) {
        this.getOuterClass().toString(stringBuffer);
        stringBuffer.append('.');
        stringBuffer.append(this.identifier.name);
    }

    boolean isInnerClass() {
        return true;
    }

    boolean isStaticInnerClass() {
        return (this.access & 8) != 0;
    }

    boolean isNonStaticInnerClass() {
        return (this.access & 8) == 0;
    }

    boolean isNonAnonymousInnerClass() {
        return true;
    }

    boolean isAccessible(ClassSymbol classSymbol) {
        if (this.equalTo(classSymbol)) {
            return true;
        }
        if (classSymbol.isInnerClass() && this.getTopLevelClass().equalTo(classSymbol.getTopLevelClass())) {
            return true;
        }
        if (this.isInnerClass(classSymbol)) {
            return true;
        }
        if ((this.access & 4) != 0) {
            RawClassSymbol rawClassSymbol = this.getOuterClass();
            while (true) {
                if (rawClassSymbol.isSuperclass(classSymbol)) {
                    return true;
                }
                if (classSymbol.isInnerClass()) {
                    RawClassSymbol rawClassSymbol2 = classSymbol.getOuterClass();
                    while (true) {
                        if (rawClassSymbol.isSuperclass(rawClassSymbol2)) {
                            return true;
                        }
                        if (!rawClassSymbol2.isInnerClass()) break;
                        rawClassSymbol2 = ((ClassSymbol)rawClassSymbol2).getOuterClass();
                    }
                }
                if (!rawClassSymbol.isInnerClass()) break;
                rawClassSymbol = ((ClassSymbol)rawClassSymbol).getOuterClass();
            }
            if (!this.isAnnotation() && (this.access & 0x208) != 0) {
                return true;
            }
        }
        return super.isAccessible(classSymbol);
    }

    void fixConstructors(Parser parser) {
        int n = 0;
        int n2 = 0;
        HiddenArgumentList hiddenArgumentList = this.hiddenArgumentList;
        while (hiddenArgumentList != null) {
            if (hiddenArgumentList.kind == 2) {
                n2 = (short)(n2 + 1);
                hiddenArgumentList.stackVarIndex = (short)n2;
                if ((hiddenArgumentList.type.typeClass & 0x28) != 0) {
                    n2 = (short)(n2 + 1);
                    this.hiddenArgCount = (short)(this.hiddenArgCount + 1);
                }
            } else {
                n = (short)(n + 1);
                hiddenArgumentList.stackVarIndex = (short)n;
            }
            this.hiddenArgCount = (short)(this.hiddenArgCount + 1);
            hiddenArgumentList = hiddenArgumentList.next;
        }
        if (this.hiddenArgCount == 0 && this.cd.ccd.dynamicInitializer == null) {
            return;
        }
        hiddenArgumentList = this.hiddenArgumentList;
        while (hiddenArgumentList != null) {
            if (hiddenArgumentList.kind == 2) {
                hiddenArgumentList.stackVarIndex = (short)(n2 + 1 - hiddenArgumentList.stackVarIndex);
            }
            hiddenArgumentList = hiddenArgumentList.next;
        }
        MethodSymbol methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (methodSymbol != null) {
            StatementList statementList;
            if (this.hiddenArgCount > 0) {
                MethodVariableSymbol methodVariableSymbol;
                int n3;
                if (n > 0) {
                    for (n3 = 0; n3 < methodSymbol.actualArgCount; ++n3) {
                        methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
                        if (methodVariableSymbol == null) continue;
                        methodVariableSymbol.varStackIndex = (short)(methodVariableSymbol.varStackIndex + n);
                    }
                }
                for (n3 = methodSymbol.actualArgCount; n3 < methodSymbol.localVarCount; ++n3) {
                    methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
                    if (methodVariableSymbol == null) continue;
                    methodVariableSymbol.varStackIndex = (short)(methodVariableSymbol.varStackIndex + this.hiddenArgCount);
                }
                methodSymbol.localVarCount = (short)(methodSymbol.localVarCount + this.hiddenArgCount);
                hiddenArgumentList = this.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 0 || hiddenArgumentList.kind == 1) {
                        methodSymbol.cmd.localVariables.add(1, null);
                    } else {
                        methodSymbol.cmd.localVariables.add(methodSymbol.actualArgCount, null);
                        if ((hiddenArgumentList.type.typeClass & 0x28) != 0) {
                            methodSymbol.cmd.localVariables.add(methodSymbol.actualArgCount, null);
                            methodSymbol.actualArgCount = (short)(methodSymbol.actualArgCount + 1);
                        }
                    }
                    methodSymbol.actualArgCount = (short)(methodSymbol.actualArgCount + 1);
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
            if ((statementList = methodSymbol.cmd.statementList) == null) {
                methodSymbol.cmd.statementList = statementList = new StatementList();
            }
            if ((methodSymbol.flags & 2) == 0) {
                DynamicInitializationStatement dynamicInitializationStatement = null;
                if (this.cd.ccd.dynamicInitializer != null) {
                    dynamicInitializationStatement = new DynamicInitializationStatement(statementList);
                    if (statementList.first == null) {
                        statementList.add(dynamicInitializationStatement);
                    } else {
                        statementList.first.insertAfter(dynamicInitializationStatement);
                    }
                }
                hiddenArgumentList = this.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    hiddenArgumentList.type = hiddenArgumentList.type.resolveType(parser, 0, true, false, false);
                    if (hiddenArgumentList.kind != 1 && (hiddenArgumentList.kind != 2 || hiddenArgumentList.fieldSymbol != null)) {
                        Expression expression = new ThisExpression(0, this);
                        expression.setType(this);
                        expression = new FieldExpression(0, hiddenArgumentList.fieldSymbol, expression);
                        expression.setType(hiddenArgumentList.fieldSymbol.type);
                        short s = hiddenArgumentList.kind == 2 ? (short)(methodSymbol.actualArgCount - hiddenArgumentList.stackVarIndex) : hiddenArgumentList.stackVarIndex;
                        ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, hiddenArgumentList.type, 0, 0, null, s);
                        expression = new AssignmentExpression(this.pos, expression, new MethodVariableExpression(0, argumentVariableSymbol));
                        ExpressionStatement expressionStatement = new ExpressionStatement(statementList, 0, expression);
                        int n4 = this.cd.fieldCount + methodSymbol.localVarCount;
                        parser.defSet = new BitSet(n4);
                        parser.posSet = new BitSet(n4);
                        parser.useSet = new BitSet(n4);
                        parser.suspendDataFlowChecking = true;
                        parser.currentMethodSymbol = methodSymbol;
                        ((Statement)expressionStatement).resolveAndCheck(parser);
                        if (statementList.first == null) {
                            statementList.add(expressionStatement);
                        } else {
                            statementList.first.insertBefore(expressionStatement);
                        }
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        parser.defSet = null;
        parser.posSet = null;
        parser.useSet = null;
        parser.currentMethodSymbol = null;
    }

    void addHiddenOuterThisArgument(TypeSymbol typeSymbol, FieldSymbol fieldSymbol) {
        HiddenArgumentList hiddenArgumentList = new HiddenArgumentList(0, typeSymbol);
        hiddenArgumentList.fieldSymbol = fieldSymbol;
        hiddenArgumentList.next = this.hiddenArgumentList;
        this.hiddenArgumentList = hiddenArgumentList;
    }

    void addHiddenSuperOuterThisArgument(InnerClassSymbol innerClassSymbol) {
        HiddenArgumentList hiddenArgumentList = new HiddenArgumentList(1, innerClassSymbol.getOuterClass());
        if (this.hiddenArgumentList == null) {
            this.hiddenArgumentList = hiddenArgumentList;
        } else if (this.hiddenArgumentList.kind == 0) {
            hiddenArgumentList.next = this.hiddenArgumentList.next;
            this.hiddenArgumentList.next = hiddenArgumentList;
        } else {
            hiddenArgumentList.next = this.hiddenArgumentList;
            this.hiddenArgumentList = hiddenArgumentList;
        }
    }

    void addHiddenFinalLocalArgument(MethodVariableSymbol methodVariableSymbol, FieldSymbol fieldSymbol) {
        HiddenArgumentList hiddenArgumentList = new HiddenArgumentList(2, methodVariableSymbol.type);
        hiddenArgumentList.localVar = methodVariableSymbol;
        hiddenArgumentList.fieldSymbol = fieldSymbol;
        if (this.hiddenArgumentList == null) {
            this.hiddenArgumentList = hiddenArgumentList;
        } else {
            HiddenArgumentList hiddenArgumentList2 = this.hiddenArgumentList;
            while (hiddenArgumentList2.next != null) {
                hiddenArgumentList2 = hiddenArgumentList2.next;
            }
            hiddenArgumentList2.next = hiddenArgumentList;
        }
    }

    boolean hasHiddenOuterThisArgument() {
        HiddenArgumentList hiddenArgumentList = this.hiddenArgumentList;
        while (hiddenArgumentList != null) {
            if (hiddenArgumentList.kind == 0) {
                return true;
            }
            hiddenArgumentList = hiddenArgumentList.next;
        }
        return false;
    }

    MethodSymbol getEnclosingMethod() {
        if (this.scope.kind < 3) {
            return null;
        }
        Scope scope = this.scope;
        while (scope.kind != 3) {
            scope = scope.getOuterScope();
        }
        return ((MethodScope)scope).methodSymbol;
    }

    static final class HiddenArgumentList {
        static final byte HA_OUTER_THIS = 0;
        static final byte HA_SUPER_OUTER_THIS = 1;
        static final byte HA_FINAL_LOCAL = 2;
        HiddenArgumentList next;
        byte kind;
        short stackVarIndex;
        TypeSymbol type;
        FieldSymbol fieldSymbol;
        MethodVariableSymbol localVar;

        HiddenArgumentList(byte by, TypeSymbol typeSymbol) {
            this.kind = by;
            this.type = typeSymbol;
        }
    }
}

