/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

abstract class IncrementExpression
extends UnaryExpression {
    boolean isPostOp;
    boolean isIncOp;
    static final /* synthetic */ boolean $assertionsDisabled;

    IncrementExpression(byte by, int n, Expression expression) {
        super(by, n, expression);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.operand;
        byte by = expression.kind;
        if (by != 1 && by != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, expression.pos, by == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        expression = expression.resolveAndCheckReadBeforeWrite(parser);
        by = expression.kind;
        if (by != 1 && by != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.operand.pos, by == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        TypeSymbol typeSymbol2 = expression.getType();
        this.setType(typeSymbol2);
        if (!(typeSymbol2.isNumericType() || parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && typeSymbol.isNumericType())) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.operand;
        TypeSymbol typeSymbol = this.getType();
        boolean bl = false;
        if (typeSymbol.typeKind != 1 && this.isPostOp) {
            expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
            bl = true;
        }
        typeSymbol = expression.getType();
        switch (typeSymbol.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 64: {
                FieldSymbol fieldSymbol;
                TypeSymbol typeSymbol2 = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, typeSymbol);
                if (bl) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(1);
                } else {
                    expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
                }
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol, typeSymbol2);
                switch (typeSymbol2.typeClass) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 4: {
                        byteCodeGenerator.generate_8_8((byte)4, this.isIncOp ? (byte)96 : 100);
                        byteCodeGenerator.incOpStackHeight(1);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                    case 8: {
                        byteCodeGenerator.generate_8_8((byte)10, this.isIncOp ? (byte)97 : 101);
                        byteCodeGenerator.incOpStackHeight(2);
                        byteCodeGenerator.decOpStackHeight(2);
                        break;
                    }
                    case 16: {
                        byteCodeGenerator.generate_8_8((byte)12, this.isIncOp ? (byte)98 : 102);
                        byteCodeGenerator.incOpStackHeight(1);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                    case 32: {
                        byteCodeGenerator.generate_8_8((byte)15, this.isIncOp ? (byte)99 : 103);
                        byteCodeGenerator.incOpStackHeight(2);
                        byteCodeGenerator.decOpStackHeight(2);
                    }
                }
                AutoBoxingExpression.generateByteCode(byteCodeGenerator, typeSymbol2, typeSymbol);
                if (this.getType().typeKind != 1 && !this.isPostOp) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(1);
                }
                expression.generateByteCodeWrite(byteCodeGenerator);
                break;
            }
            case 4: {
                FieldSymbol fieldSymbol;
                if (typeSymbol.typeKind == 6 && expression instanceof MethodVariableExpression) {
                    MethodVariableExpression methodVariableExpression = (MethodVariableExpression)expression;
                    short s = methodVariableExpression.variable.varStackIndex;
                    if (s <= 255) {
                        byteCodeGenerator.generate_8_8_8((byte)-124, (byte)s, this.isIncOp ? (byte)1 : -1);
                        if (this.isPostOp || this.getType().typeKind == 1) break;
                        expression.generateByteCode(byteCodeGenerator);
                        break;
                    }
                }
                if (bl) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(2);
                } else {
                    expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
                    byteCodeGenerator.incOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_8((byte)4, this.isIncOp ? (byte)96 : 100);
                byteCodeGenerator.decOpStackHeight(1);
                if (typeSymbol.typeKind != 6) {
                    byteCodeGenerator.generateNarrowingPrimitiveConversion((byte)4, typeSymbol.typeKind);
                }
                if (this.getType().typeKind != 1 && !this.isPostOp) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(1);
                }
                expression.generateByteCodeWrite(byteCodeGenerator);
                break;
            }
            case 8: {
                FieldSymbol fieldSymbol;
                if (bl) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)94);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)92);
                        } else {
                            byteCodeGenerator.generate_8((byte)93);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(4);
                } else {
                    expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
                    byteCodeGenerator.incOpStackHeight(2);
                }
                byteCodeGenerator.generate_8_8((byte)10, this.isIncOp ? (byte)97 : 101);
                byteCodeGenerator.decOpStackHeight(2);
                if (this.getType().typeKind != 1 && !this.isPostOp) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)94);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)92);
                        } else {
                            byteCodeGenerator.generate_8((byte)93);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(2);
                }
                expression.generateByteCodeWrite(byteCodeGenerator);
                break;
            }
            case 16: {
                FieldSymbol fieldSymbol;
                if (bl) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(2);
                } else {
                    expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
                    byteCodeGenerator.incOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_8((byte)12, this.isIncOp ? (byte)98 : 102);
                byteCodeGenerator.decOpStackHeight(1);
                if (this.getType().typeKind != 1 && !this.isPostOp) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)91);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)89);
                        } else {
                            byteCodeGenerator.generate_8((byte)90);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(1);
                }
                expression.generateByteCodeWrite(byteCodeGenerator);
                break;
            }
            case 32: {
                FieldSymbol fieldSymbol;
                if (bl) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)94);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)92);
                        } else {
                            byteCodeGenerator.generate_8((byte)93);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(4);
                } else {
                    expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
                    byteCodeGenerator.incOpStackHeight(2);
                }
                byteCodeGenerator.generate_8_8((byte)15, this.isIncOp ? (byte)99 : 103);
                byteCodeGenerator.decOpStackHeight(2);
                if (this.getType().typeKind != 1 && !this.isPostOp) {
                    if (expression.kind == 3) {
                        byteCodeGenerator.generate_8((byte)94);
                    } else if (expression instanceof MethodVariableExpression) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                        if ((fieldSymbol.access & 8) != 0) {
                            byteCodeGenerator.generate_8((byte)92);
                        } else {
                            byteCodeGenerator.generate_8((byte)93);
                        }
                    }
                    byteCodeGenerator.incOpStackHeight(2);
                }
                expression.generateByteCodeWrite(byteCodeGenerator);
            }
        }
    }

    static {
        $assertionsDisabled = !IncrementExpression.class.desiredAssertionStatus();
    }
}

