/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedStaticImportList;
import oracle.ojc.compiler.UnresolvedSymbol;

final class ImportDescriptor {
    static final byte ID_STAR = 1;
    static final byte ID_STATIC = 2;
    static final byte ID_PACKAGENOTFOUND = 4;
    static final byte ID_PROCESSED = 8;
    ImportDescriptor next;
    UnresolvedSymbol importSymbol;
    ArrayList importSymbolList;
    int pos;
    byte flags;

    ImportDescriptor(int n, UnresolvedSymbol unresolvedSymbol, byte by) {
        this.pos = n;
        this.importSymbol = unresolvedSymbol;
        this.flags = by;
        this.importSymbolList = new ArrayList();
    }

    void importInnerClasses(Parser parser, RawClassSymbol rawClassSymbol, int n) {
        if (rawClassSymbol.classScope == null) {
            rawClassSymbol.loadType(parser, n, true, true);
        }
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        TypeSymbolList typeSymbolList = rawClassSymbol.cd.innerClassList;
        if (typeSymbolList != null) {
            boolean bl;
            StorageScope storageScope = parser.globalScope;
            StorageScope storageScope2 = parser.currentPackageScope;
            boolean bl2 = bl = parser.currentPackageScope == rawClassSymbol.getPackageScope();
            do {
                TypeSymbol typeSymbol;
                if ((typeSymbol = typeSymbolList.typeSymbol).isLocalInnerClass() || !bl && (typeSymbol.access & 1) == 0) continue;
                InnerClassSymbol innerClassSymbol = (InnerClassSymbol)typeSymbol;
                if (storageScope2 == null || storageScope2.lookupImportSymbol(innerClassSymbol.identifier, (byte)32) != null || storageScope.lookupImportSymbol(innerClassSymbol.identifier, (byte)32) != null) continue;
                ImportSymbol importSymbol = new ImportSymbol(n, innerClassSymbol, this);
                importSymbol.flags = (byte)(importSymbol.flags | 0xC);
                this.importSymbolList.add(importSymbol);
                storageScope2.enterSymbol(importSymbol);
                this.importInnerClasses(parser, innerClassSymbol, n);
            } while ((typeSymbolList = typeSymbolList.next) != null);
        }
    }

    private void processImport(Parser parser, SourceFile sourceFile) {
        IdentifierList identifierList = this.importSymbol.qualifierList;
        if ((this.flags & 2) != 0) {
            Identifier identifier;
            UnresolvedClassSymbol unresolvedClassSymbol;
            if ((this.flags & 8) != 0) {
                return;
            }
            if ((this.flags & 1) != 0) {
                unresolvedClassSymbol = new UnresolvedClassSymbol(identifierList, this.importSymbol.identifier, null, parser.globalScope);
                identifier = null;
            } else {
                identifier = this.importSymbol.identifier;
                IdentifierList identifierList2 = null;
                while (identifierList != null) {
                    if (identifierList.next == null) {
                        identifier = identifierList.identifier;
                        if (identifierList2 == null) {
                            identifierList = null;
                            break;
                        }
                        identifierList2.next = null;
                        identifierList = this.importSymbol.qualifierList;
                        break;
                    }
                    identifierList2 = identifierList;
                    identifierList = identifierList.next;
                }
                unresolvedClassSymbol = new UnresolvedClassSymbol(identifierList, identifier, null, parser.globalScope);
                identifier = this.importSymbol.identifier;
            }
            UnresolvedStaticImportList unresolvedStaticImportList = new UnresolvedStaticImportList(this, unresolvedClassSymbol, identifier);
            unresolvedStaticImportList.next = sourceFile.usil;
            sourceFile.usil = unresolvedStaticImportList;
            this.flags = (byte)(this.flags | 8);
            return;
        }
        Scope scope = parser.globalScope;
        if (identifierList != null) {
            RawClassSymbol rawClassSymbol;
            PackageSymbol packageSymbol;
            PackageScope packageScope;
            Symbol symbol = scope.lookupSpecificSymbolInScope(identifierList.identifier, 32, false);
            if (symbol == null) {
                do {
                    if ((symbol = scope.lookupSpecificSymbolInScope(identifierList.identifier, 16, false)) == null) {
                        symbol = scope.lookupSpecificSymbolInScope(identifierList.identifier, 32, false);
                        if (symbol != null) break;
                        parser.findSourceFileForIdentifier(scope, identifierList.identifier);
                        packageScope = new PackageScope(parser, (StorageScope)scope);
                        packageSymbol = new PackageSymbol(this.pos, identifierList.identifier, packageScope);
                        symbol = packageSymbol;
                        scope.enterSymbol(packageSymbol);
                        packageScope.packageSymbol = packageSymbol;
                        this.flags = (byte)(this.flags | 4);
                    } else {
                        packageSymbol = (PackageSymbol)symbol;
                    }
                    packageSymbol.packageScope.readPackage();
                    scope = packageSymbol.packageScope;
                } while ((identifierList = identifierList.next) != null);
            }
            while (identifierList != null) {
                symbol = scope.lookupSpecificSymbolInScope(identifierList.identifier, 32, false);
                if (symbol == null) {
                    parser.error(Message.errorNotFound, identifierList.pos, false, Message.classString + " " + identifierList.identifier.toString(), "");
                    return;
                }
                rawClassSymbol = (RawClassSymbol)symbol;
                rawClassSymbol.resolveType(parser, identifierList.pos, true, true, false);
                scope = rawClassSymbol.classScope;
                identifierList = identifierList.next;
            }
            if ((this.flags & 1) != 0) {
                if ((symbol.kind & 0x20) != 0) {
                    this.importInnerClasses(parser, (RawClassSymbol)symbol, this.pos);
                    return;
                }
                packageSymbol = (PackageSymbol)symbol;
                scope = packageSymbol.packageScope;
                symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 48, false);
                if (symbol != null) {
                    if ((symbol.kind & 0x20) != 0) {
                        rawClassSymbol = (RawClassSymbol)symbol;
                        if ((rawClassSymbol.access & 1) == 0) {
                            parser.error(Message.errorNotPublic, this.pos, false, rawClassSymbol.errorName(), packageSymbol.errorName());
                        } else {
                            this.importInnerClasses(parser, rawClassSymbol, this.pos);
                        }
                        return;
                    }
                    packageSymbol = (PackageSymbol)symbol;
                    packageScope = packageSymbol.packageScope;
                } else {
                    packageScope = new PackageScope(parser, (StorageScope)scope);
                    packageSymbol = new PackageSymbol(this.pos, this.importSymbol.identifier, packageScope);
                    scope.enterSymbol(packageSymbol);
                    packageScope.packageSymbol = packageSymbol;
                    packageScope.readPackage();
                }
                packageScope.importPackage(this, this.pos, true);
            } else {
                symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 32, false);
                if (symbol != null) {
                    rawClassSymbol = (RawClassSymbol)symbol;
                } else {
                    rawClassSymbol = scope.kind == 2 ? new InnerClassSymbol(this.pos, this.importSymbol.identifier, 0, null, null, false) : new RawClassSymbol(this.pos, this.importSymbol.identifier, 0, null, null, false, false);
                    scope.enterSymbol(rawClassSymbol);
                }
                rawClassSymbol.loadType(parser, this.pos, null, true, true);
                packageScope = (PackageScope)parser.currentPackageScope;
                ImportSymbol importSymbol = packageScope.lookupImportSymbol(rawClassSymbol.identifier, (byte)32);
                if (importSymbol != null) {
                    if (importSymbol.importedSymbol == rawClassSymbol) {
                        parser.warning(null, Message.warningDuplicateImport, this.pos, rawClassSymbol.errorName());
                        importSymbol.flags = (byte)(importSymbol.flags & 0xFFFFFFF3);
                    } else if ((importSymbol.flags & 4) == 0) {
                        parser.error(Message.errorDoubleImport, this.importSymbol.pos, false, rawClassSymbol.errorName());
                    } else {
                        importSymbol = new ImportSymbol(this.pos, rawClassSymbol, this);
                        importSymbol.flags = (byte)(importSymbol.flags | 1);
                        this.importSymbolList.add(importSymbol);
                        parser.currentPackageScope.enterSymbol(importSymbol);
                        this.importInnerClasses(parser, rawClassSymbol, this.pos);
                    }
                } else {
                    importSymbol = new ImportSymbol(this.pos, rawClassSymbol, this);
                    importSymbol.flags = (byte)(importSymbol.flags | 1);
                    this.importSymbolList.add(importSymbol);
                    parser.currentPackageScope.enterSymbol(importSymbol);
                    this.importInnerClasses(parser, rawClassSymbol, this.pos);
                }
            }
        } else if ((this.flags & 1) != 0) {
            PackageScope packageScope;
            Symbol symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 16, false);
            if (symbol != null) {
                PackageSymbol packageSymbol = (PackageSymbol)symbol;
                packageScope = packageSymbol.packageScope;
            } else {
                packageScope = new PackageScope(parser, (StorageScope)scope);
                PackageSymbol packageSymbol = new PackageSymbol(this.pos, this.importSymbol.identifier, packageScope);
                scope.enterSymbol(packageSymbol);
                packageScope.packageSymbol = packageSymbol;
                packageScope.readPackage();
                this.flags = (byte)(this.flags | 4);
            }
            packageScope.importPackage(this, this.pos, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processImports(Parser parser, SourceFile sourceFile) {
        ArrayList arrayList = new ArrayList();
        parser.currentPackageScope = sourceFile.packageScope;
        if (parser.currentPackageScope != null) {
            parser.currentPackageScope.recordDeclarations(arrayList);
            try {
                ImportDescriptor importDescriptor = sourceFile.importList;
                while (importDescriptor != null) {
                    importDescriptor.processImport(parser, sourceFile);
                    importDescriptor = importDescriptor.next;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                parser.currentPackageScope.recordDeclarations(null);
                int n = arrayList.size();
                if (n > 0) {
                    sourceFile.importDeclarations = arrayList.toArray(new Symbol[n]);
                    parser.currentPackageScope.removeDeclarations(sourceFile.importDeclarations);
                }
                throw throwable;
            }
            parser.currentPackageScope.recordDeclarations(null);
            int n = arrayList.size();
            if (n > 0) {
                sourceFile.importDeclarations = arrayList.toArray(new Symbol[n]);
                parser.currentPackageScope.removeDeclarations(sourceFile.importDeclarations);
            }
        }
    }
}

