/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class FloatConstantExpression
extends ConstantExpression {
    float fval;

    FloatConstantExpression(int n, float f) {
        super(n, TypeSymbol.floatSymbol);
        this.fval = f;
    }

    Expression copyConstantExpression() {
        return new FloatConstantExpression(this.pos, this.fval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        int n = Float.floatToIntBits(this.fval);
        if (n == 0) {
            byteCodeGenerator.generate_8((byte)11);
        } else if (n == 1065353216) {
            byteCodeGenerator.generate_8((byte)12);
        } else if (n == 0x40000000) {
            byteCodeGenerator.generate_8((byte)13);
        } else {
            short s = byteCodeGenerator.constantPool.enterConstantPoolFloat(this.fval);
            if (s > 255) {
                byteCodeGenerator.generate_8_16((byte)19, s);
            } else {
                byteCodeGenerator.generate_8_8((byte)18, (byte)s);
            }
        }
        byteCodeGenerator.incOpStackHeight(1);
    }
}

