/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class Expression {
    static final byte EK_ERROR = 0;
    static final byte EK_IDENTIFIER = 1;
    static final byte EK_CONSTANT = 2;
    static final byte EK_ARRAY = 3;
    static final byte EK_INVOKE = 4;
    static final byte EK_ASSIGNMENT = 5;
    static final byte EK_ASSIGNMENT_PLUS = 6;
    static final byte EK_ASSIGNMENT_MINUS = 7;
    static final byte EK_ASSIGNMENT_MULTIPLY = 8;
    static final byte EK_ASSIGNMENT_DIVIDE = 9;
    static final byte EK_ASSIGNMENT_MODULO = 10;
    static final byte EK_ASSIGNMENT_BIT_OR = 11;
    static final byte EK_ASSIGNMENT_BIT_XOR = 12;
    static final byte EK_ASSIGNMENT_BIT_AND = 13;
    static final byte EK_ASSIGNMENT_SHIFT_LEFT = 14;
    static final byte EK_ASSIGNMENT_SHIFT_RIGHT = 15;
    static final byte EK_ASSIGNMENT_UNSIGNED_SHIFT_RIGHT = 16;
    static final byte EK_LOGICAL_OR = 17;
    static final byte EK_LOGICAL_AND = 18;
    static final byte EK_BIT_OR = 19;
    static final byte EK_BIT_XOR = 20;
    static final byte EK_BIT_AND = 21;
    static final byte EK_EQUAL = 22;
    static final byte EK_NOT_EQUAL = 23;
    static final byte EK_LESS = 24;
    static final byte EK_GREATER = 25;
    static final byte EK_LESS_OR_EQUAL = 26;
    static final byte EK_GREATER_OR_EQUAL = 27;
    static final byte EK_INSTANCEOF = 28;
    static final byte EK_CONDITIONAL = 29;
    static final byte EK_SHIFT_LEFT = 30;
    static final byte EK_SHIFT_RIGHT = 31;
    static final byte EK_UNSIGNED_SHIFT_RIGHT = 32;
    static final byte EK_PLUS = 33;
    static final byte EK_MINUS = 34;
    static final byte EK_MULTIPLY = 35;
    static final byte EK_DIVIDE = 36;
    static final byte EK_MODULO = 37;
    static final byte EK_UNARYPLUS = 38;
    static final byte EK_NEGATE = 39;
    static final byte EK_BIN_COMPLEMENT = 40;
    static final byte EK_POST_INCREMENT = 41;
    static final byte EK_POST_DECREMENT = 42;
    static final byte EK_PRE_INCREMENT = 43;
    static final byte EK_PRE_DECREMENT = 44;
    static final byte EK_LOGICAL_NOT = 45;
    static final byte EK_CAST = 46;
    static final byte EK_NEW = 47;
    static final byte EK_CLASS = 48;
    static final byte EK_ARRAY_LENGTH = 49;
    static final byte EK_ARRAY_INITIALIZER = 50;
    static final byte EK_APPENDSTRING = 51;
    static final byte EK_AUTOBOXING = 53;
    static final byte EK_AUTOUNBOXING = 54;
    static final byte EK_MAX = 55;
    private static boolean[] isStatementExpressionMap;
    final byte kind;
    final int pos;
    private TypeSymbol type;
    static final /* synthetic */ boolean $assertionsDisabled;

    Expression(byte by, int n) {
        this.kind = by;
        this.pos = n;
    }

    static void initializeExpressions() {
        ErrorExpression.initializeStatics();
    }

    static void releaseExpressions() {
        ErrorExpression.releaseStatics();
    }

    short getAccess() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    String errorName() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    final TypeSymbol getType() {
        return this.type;
    }

    void setType(TypeSymbol typeSymbol) {
        this.type = typeSymbol;
    }

    boolean isConstantBooleanExpression() {
        return false;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        return false;
    }

    boolean isLogicalExpression() {
        return false;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        if (!$assertionsDisabled && !this.isLogicalExpression()) {
            throw new AssertionError();
        }
        return null;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        if (!$assertionsDisabled && !this.isLogicalExpression()) {
            throw new AssertionError();
        }
        return null;
    }

    static boolean isStatementExpression(byte by) {
        return isStatementExpressionMap[by];
    }

    Expression foldExpression() {
        return this;
    }

    Expression constantFolding() {
        return this;
    }

    abstract Expression resolveAndCheck(Parser var1);

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        return this.resolveAndCheck(parser);
    }

    Expression resolveAndCheckWrite(Parser parser) {
        return this.resolveAndCheck(parser);
    }

    void markDefined(Parser parser) {
    }

    boolean takeAssignmentContext() {
        return false;
    }

    private static int getHierarchyDepth(ClassSymbol classSymbol) {
        int n = 0;
        while (classSymbol != null) {
            ++n;
            classSymbol = classSymbol.getSuperClassSymbol();
        }
        return n;
    }

    static TypeSymbol findCommonSuperclass(Parser parser, TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (!typeSymbol.isClass() || !typeSymbol2.isClass()) {
            return parser.javaLangObjectPcs;
        }
        ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
        int n = Expression.getHierarchyDepth(classSymbol);
        ClassSymbol classSymbol2 = (ClassSymbol)typeSymbol2;
        int n2 = Expression.getHierarchyDepth(classSymbol2);
        if (n2 > n) {
            int n3 = n;
            n = n2;
            n2 = n3;
            classSymbol = (ClassSymbol)typeSymbol2;
            classSymbol2 = (ClassSymbol)typeSymbol;
        }
        while (n > n2) {
            --n;
            classSymbol = classSymbol.getSuperClassSymbol();
        }
        while (!classSymbol.equalTo(classSymbol2)) {
            classSymbol = classSymbol.getSuperClassSymbol();
            classSymbol2 = classSymbol2.getSuperClassSymbol();
        }
        return classSymbol;
    }

    Expression promoteType(Parser parser, TypeSymbol typeSymbol) {
        Expression expression;
        TypeSymbol typeSymbol2 = this.type;
        if (typeSymbol2.equalTo(typeSymbol)) {
            return this;
        }
        byte by = typeSymbol.typeKind;
        byte by2 = typeSymbol2.typeKind;
        if (typeSymbol.isErroneous() || typeSymbol2.isErroneous()) {
            return this;
        }
        TypeSymbol typeSymbol3 = null;
        if (parser.options.sourceJDKVersion >= 150) {
            if (typeSymbol2.isPrimitiveType() && typeSymbol.isClass()) {
                typeSymbol3 = typeSymbol.equalTo(parser.javaLangNumberSymbol) || ((ClassSymbol)typeSymbol).isSuperclass(parser.javaLangNumberSymbol) ? typeSymbol2 : BoxingExpression.getPrimitiveType(parser, typeSymbol);
            } else if (typeSymbol.isPrimitiveType() && typeSymbol2.isReferenceType()) {
                typeSymbol3 = BoxingExpression.getPrimitiveType(parser, typeSymbol2);
            }
        }
        switch (by2) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
            case 10: {
                if (typeSymbol3 != null) {
                    if (typeSymbol3.typeKind != by) {
                        switch (typeSymbol3.typeKind) {
                            default: {
                                if (!TypeSymbol.isWider(typeSymbol3.typeKind, by)) break;
                                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return new ErrorExpression(error);
                            }
                            case 2: {
                                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return new ErrorExpression(error);
                            }
                            case 3: {
                                if (by != 4) break;
                                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                    }
                    return new AutoUnboxingExpression(this, typeSymbol);
                }
            }
            case 11: {
                if (typeSymbol2 == ReferenceTypeSymbol.nullTypeSymbol || typeSymbol == ReferenceTypeSymbol.nullTypeSymbol) {
                    return this;
                }
                if (typeSymbol.equalTo(parser.javaLangObjectSymbol)) {
                    return this;
                }
                if (!(typeSymbol instanceof ReferenceTypeSymbol)) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol2;
                ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol;
                if (!referenceTypeSymbol.isCastCompatible(parser, referenceTypeSymbol2)) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                return this;
            }
            case 2: {
                if (typeSymbol3 != null && by2 == typeSymbol3.typeKind) {
                    return new AutoBoxingExpression(this, typeSymbol);
                }
                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
            case 3: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(by2, by) || by == 4) {
                    IntConstantExpression intConstantExpression = null;
                    int n = 0;
                    if (by == 4) {
                        if (this.kind == 2) {
                            intConstantExpression = (IntConstantExpression)this;
                            n = intConstantExpression.ival;
                        } else {
                            ConstantExpression constantExpression = this.getConstInitExpressionIfFinal();
                            if (constantExpression instanceof IntConstantExpression) {
                                intConstantExpression = (IntConstantExpression)constantExpression;
                                n = intConstantExpression.ival;
                            }
                        }
                    }
                    if (intConstantExpression != null && 0 <= n && n <= 127) {
                        Expression expression2 = new CharConstantExpression(this.pos, (char)n);
                        if (typeSymbol3 != null) {
                            expression2 = new AutoBoxingExpression(expression2, typeSymbol);
                        }
                        return expression2;
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 4: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (by2 != by && TypeSymbol.isWiderOrSame(by2, by)) {
                    IntConstantExpression intConstantExpression = null;
                    CharConstantExpression charConstantExpression = null;
                    int n = 0;
                    char c = '\u0000';
                    if (this.kind == 2) {
                        charConstantExpression = (CharConstantExpression)this;
                        c = charConstantExpression.cval;
                    } else {
                        ConstantExpression constantExpression = this.getConstInitExpressionIfFinal();
                        if (constantExpression instanceof CharConstantExpression) {
                            charConstantExpression = (CharConstantExpression)constantExpression;
                            c = charConstantExpression.cval;
                        } else if (constantExpression instanceof IntConstantExpression) {
                            intConstantExpression = (IntConstantExpression)constantExpression;
                            n = intConstantExpression.ival;
                        }
                    }
                    if (charConstantExpression != null) {
                        boolean bl = false;
                        switch (by) {
                            default: {
                                break;
                            }
                            case 3: {
                                bl = c <= '\u007f';
                                break;
                            }
                            case 5: {
                                boolean bl2 = bl = c <= Short.MAX_VALUE;
                            }
                        }
                        if (bl) {
                            if (typeSymbol3 != null) {
                                intConstantExpression = new IntConstantExpression(this.pos, typeSymbol3, c);
                                return new AutoBoxingExpression(intConstantExpression, typeSymbol);
                            }
                            return new IntConstantExpression(this.pos, typeSymbol, c);
                        }
                    } else if (intConstantExpression != null) {
                        boolean bl = false;
                        switch (by) {
                            default: {
                                break;
                            }
                            case 3: {
                                bl = n <= 127;
                                break;
                            }
                            case 5: {
                                boolean bl3 = bl = n <= Short.MAX_VALUE;
                            }
                        }
                        if (bl) {
                            if (typeSymbol3 != null) {
                                return new AutoBoxingExpression(intConstantExpression, typeSymbol);
                            }
                            return intConstantExpression;
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 5: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (by2 != by && TypeSymbol.isWiderOrSame(by2, by)) {
                    IntConstantExpression intConstantExpression = null;
                    int n = 0;
                    if (this.kind == 2) {
                        intConstantExpression = (IntConstantExpression)this;
                        n = intConstantExpression.ival;
                    } else {
                        ConstantExpression constantExpression = this.getConstInitExpressionIfFinal();
                        if (constantExpression instanceof IntConstantExpression) {
                            intConstantExpression = (IntConstantExpression)constantExpression;
                            n = intConstantExpression.ival;
                        }
                    }
                    if (intConstantExpression != null) {
                        switch (by) {
                            default: {
                                break;
                            }
                            case 3: {
                                if (-128 > n || n > 127) break;
                                intConstantExpression.setTypeExempt(TypeSymbol.byteSymbol);
                                if (typeSymbol3 != null) {
                                    return new AutoBoxingExpression(intConstantExpression, typeSymbol);
                                }
                                return intConstantExpression;
                            }
                            case 4: {
                                if (0 > n || n > Short.MAX_VALUE) break;
                                Expression expression3 = new CharConstantExpression(intConstantExpression.pos, (char)n);
                                if (typeSymbol3 != null) {
                                    expression3 = new AutoBoxingExpression(expression3, typeSymbol);
                                }
                                return expression3;
                            }
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 6: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(by2, by)) {
                    IntConstantExpression intConstantExpression = null;
                    int n = 0;
                    if (this.kind == 2) {
                        intConstantExpression = (IntConstantExpression)this;
                        n = intConstantExpression.ival;
                    } else {
                        ConstantExpression constantExpression = this.getConstInitExpressionIfFinal();
                        if (constantExpression instanceof IntConstantExpression) {
                            intConstantExpression = (IntConstantExpression)constantExpression;
                            n = intConstantExpression.ival;
                        }
                    }
                    if (intConstantExpression != null) {
                        switch (by) {
                            default: {
                                break;
                            }
                            case 3: {
                                if (-128 > n || n > 127) break;
                                intConstantExpression.setTypeExempt(TypeSymbol.byteSymbol);
                                if (typeSymbol3 != null) {
                                    return new AutoBoxingExpression(intConstantExpression, typeSymbol);
                                }
                                return intConstantExpression;
                            }
                            case 4: {
                                if (0 > n || n > 65535) break;
                                Expression expression4 = new CharConstantExpression(intConstantExpression.pos, (char)n);
                                if (typeSymbol3 != null) {
                                    expression4 = new AutoBoxingExpression(expression4, typeSymbol);
                                }
                                return expression4;
                            }
                            case 5: {
                                if (Short.MIN_VALUE > n || n > Short.MAX_VALUE) break;
                                intConstantExpression.setTypeExempt(TypeSymbol.shortSymbol);
                                if (typeSymbol3 != null) {
                                    return new AutoBoxingExpression(intConstantExpression, typeSymbol);
                                }
                                return intConstantExpression;
                            }
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 7: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(by2, by)) {
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 8: {
                if (typeSymbol3 != null && typeSymbol3.isNumericType()) {
                    by = typeSymbol3.typeKind;
                } else if (!typeSymbol.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(by2, by)) {
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (typeSymbol3 == null) break;
                return new AutoBoxingExpression(this, typeSymbol);
            }
            case 9: {
                if (typeSymbol3 != null && by2 == typeSymbol3.typeKind) {
                    return new AutoBoxingExpression(this, typeSymbol);
                }
                Error error = !typeSymbol.isNumericType() ? parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName()) : parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
        }
        if (this.kind == 2 && typeSymbol2.isNumericType()) {
            expression = CastExpression.castNumericConstant(this, typeSymbol, false);
        } else {
            expression = new CastExpression(this.pos, this, typeSymbol);
            expression.type = typeSymbol;
        }
        return expression;
    }

    private ConstantExpression getConstInitExpressionIfFinal() {
        if (this.kind == 1 && this instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)this;
            if (fieldExpression.field.kind == 2) {
                FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
                if ((fieldSymbol.access & 0x10) != 0 && fieldSymbol.initializer instanceof ConstantExpression) {
                    return (ConstantExpression)fieldSymbol.initializer;
                }
            }
        }
        return null;
    }

    abstract void generateByteCode(ByteCodeGenerator var1);

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean bl) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean bl) {
        if (!$assertionsDisabled && this.type.typeKind != 2) {
            throw new AssertionError();
        }
        this.generateByteCode(byteCodeGenerator);
        if (bl) {
            byteCodeGenerator.generateBranch_ifeq(label);
        } else {
            byteCodeGenerator.generateBranch_ifne(label);
        }
        byteCodeGenerator.decOpStackHeight(1);
    }

    static {
        $assertionsDisabled = !Expression.class.desiredAssertionStatus();
        isStatementExpressionMap = new boolean[55];
        Expression.isStatementExpressionMap[4] = true;
        Expression.isStatementExpressionMap[5] = true;
        Expression.isStatementExpressionMap[6] = true;
        Expression.isStatementExpressionMap[7] = true;
        Expression.isStatementExpressionMap[8] = true;
        Expression.isStatementExpressionMap[9] = true;
        Expression.isStatementExpressionMap[10] = true;
        Expression.isStatementExpressionMap[11] = true;
        Expression.isStatementExpressionMap[12] = true;
        Expression.isStatementExpressionMap[13] = true;
        Expression.isStatementExpressionMap[14] = true;
        Expression.isStatementExpressionMap[15] = true;
        Expression.isStatementExpressionMap[16] = true;
        Expression.isStatementExpressionMap[41] = true;
        Expression.isStatementExpressionMap[42] = true;
        Expression.isStatementExpressionMap[43] = true;
        Expression.isStatementExpressionMap[44] = true;
    }
}

