/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class DoubleConstantExpression
extends ConstantExpression {
    double dval;

    DoubleConstantExpression(int n, double d) {
        super(n, TypeSymbol.doubleSymbol);
        this.dval = d;
    }

    Expression copyConstantExpression() {
        return new DoubleConstantExpression(this.pos, this.dval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        long l = Double.doubleToLongBits(this.dval);
        if (l == 0L) {
            byteCodeGenerator.generate_8((byte)14);
        } else if (l == 0x3FF0000000000000L) {
            byteCodeGenerator.generate_8((byte)15);
        } else {
            short s = byteCodeGenerator.constantPool.enterConstantPoolDouble(this.dval);
            byteCodeGenerator.generate_8_16((byte)20, s);
        }
        byteCodeGenerator.incOpStackHeight(2);
    }
}

