/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.NumericBinaryExpression;

final class DivideExpression
extends NumericBinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    DivideExpression(int n, Expression expression, Expression expression2) {
        super((byte)36, n, expression, expression2);
    }

    strictfp Expression foldExpression() {
        Expression expression = this.leftOperand;
        Expression expression2 = this.rightOperand;
        if (expression.kind == 2 && expression2.kind == 2) {
            switch (expression.getType().typeClass) {
                case 4: {
                    int n = ((ConstantExpression)expression2).getIntConstValue();
                    if (n == 0) break;
                    return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)expression).getIntConstValue() / n);
                }
                case 8: {
                    long l = ((LongConstantExpression)expression2).lval;
                    if (l == 0L) break;
                    return new LongConstantExpression(this.pos, ((LongConstantExpression)expression).lval / l);
                }
                case 16: {
                    float f = ((FloatConstantExpression)expression2).fval;
                    if (f == 0.0f) break;
                    return new FloatConstantExpression(this.pos, ((FloatConstantExpression)expression).fval / f);
                }
                case 32: {
                    double d = ((DoubleConstantExpression)expression2).dval;
                    if (d == 0.0) break;
                    return new DoubleConstantExpression(this.pos, ((DoubleConstantExpression)expression).dval / d);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8((byte)108);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)109);
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)110);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)111);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
    }

    public String toString() {
        return "/";
    }

    static {
        $assertionsDisabled = !DivideExpression.class.desiredAssertionStatus();
    }
}

