/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LabeledStatement;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class ContinueStatement
extends Statement {
    LabelSymbol labelSymbol;
    LabelSymbol continueSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ContinueStatement(StatementList statementList, int n, LabelSymbol labelSymbol) {
        super(statementList, n, (byte)10);
        this.labelSymbol = labelSymbol;
    }

    void resolveAndCheck(Parser parser) {
        this.parent.updateDefUseSetsAfterContinue(parser, this.labelSymbol);
        if (this.labelSymbol != null) {
            LabeledStatement labeledStatement = this.labelSymbol.labeledStatement;
            if (labeledStatement != null) {
                StatementList statementList = labeledStatement.labeledStatements;
                if (statementList == null || statementList.first != (statementList.last.kind == 21 ? statementList.last.prev : statementList.last) || !(statementList.first instanceof LoopStatement) || labeledStatement.labelList.symbol != this.labelSymbol) {
                    parser.error(Message.errorNotLoopLabel, this.pos, false, this.labelSymbol.identifier.toString());
                } else {
                    LoopStatement loopStatement = (LoopStatement)statementList.first;
                    this.continueSymbol = loopStatement.loopRec.getContinueSymbol();
                }
            }
        } else {
            SwitchLoopList switchLoopList = parser.innerSwitchLoop;
            while (switchLoopList != null && switchLoopList.loopStmt == null) {
                switchLoopList = switchLoopList.outerSwitchLoop;
            }
            if (switchLoopList == null) {
                parser.error(Message.errorContinueOutside, this.pos, false);
            } else {
                this.continueSymbol = switchLoopList.getContinueSymbol();
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        SwitchLoopList switchLoopList;
        Statement statement;
        if (this.labelSymbol != null) {
            statement = this.labelSymbol.labeledStatement;
        } else {
            switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
            while (true) {
                if (!$assertionsDisabled && switchLoopList == null) {
                    throw new AssertionError();
                }
                if (switchLoopList.loopStmt != null) {
                    statement = switchLoopList.loopStmt;
                    break;
                }
                switchLoopList = switchLoopList.outerSwitchLoop;
            }
        }
        StatementList statementList = this.parent;
        SwitchLoopList switchLoopList2 = switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
        while (true) {
            if (!$assertionsDisabled && statementList.parent == null) {
                throw new AssertionError();
            }
            if (statementList.parent == statement) break;
            switch (statementList.parent.kind) {
                case 17: {
                    TryStatement tryStatement = (TryStatement)statementList.parent;
                    if (tryStatement.finallyBody == null || tryStatement.finallyBody == statementList) break;
                    if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
                        if (tryStatement.finallyLabel == null) {
                            tryStatement.finallyLabel = new Label();
                        }
                        byteCodeGenerator.generateBranch_jsr(tryStatement.finallyLabel);
                        break;
                    }
                    byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
                    tryStatement.finallyBody.generateByteCode(byteCodeGenerator);
                    byteCodeGenerator.parser.innerSwitchLoop = switchLoopList2;
                    break;
                }
                case 15: {
                    SynchronizedStatement synchronizedStatement = (SynchronizedStatement)statementList.parent;
                    byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, synchronizedStatement.localVar);
                    byteCodeGenerator.generate_8((byte)-61);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            }
            if (switchLoopList.switchStmt != null && switchLoopList.switchStmt.bodyStatements == statementList || switchLoopList.loopStmt != null && switchLoopList.loopStmt.bodyStatements == statementList) {
                switchLoopList = switchLoopList.outerSwitchLoop;
            }
            statementList = statementList.parent.parent;
        }
        if (this.continueSymbol != null) {
            byteCodeGenerator.generateBranch_goto(this.continueSymbol.label);
        } else if (!$assertionsDisabled && !byteCodeGenerator.parser.errorFound) {
            throw new AssertionError();
        }
    }

    boolean canReachNextStatement(boolean bl) {
        return false;
    }

    static {
        $assertionsDisabled = !ContinueStatement.class.desiredAssertionStatus();
    }
}

