/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;

final class ConstantPoolUtf8
extends ConstantPoolEntry {
    ConstantPoolUtf8 nextHashed;
    char[] string;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConstantPoolUtf8(char[] cArray) {
        super((byte)1);
        this.string = cArray;
    }

    int write(ClassFileWriter classFileWriter) throws IOException {
        char c;
        int n;
        char[] cArray = this.string;
        int n2 = n = cArray.length;
        while (--n2 >= 0) {
            c = cArray[n2];
            if (c != '\u0000' && c < '\u0080') continue;
            if (c >= '\u0800') {
                n += 2;
                continue;
            }
            ++n;
        }
        if (n > 65535) {
            Parser parser = classFileWriter.parser;
            parser.error(Message.errorConstantPoolTooLarge, parser.currentClassSymbol.pos, false, parser.currentClassSymbol.errorName());
        }
        int n3 = classFileWriter.ensureWriteBufferCapacity(3);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n3 + 2] = (byte)n;
        byArray[n3 + 1] = (byte)(n >> 8);
        byArray[n3] = 1;
        classFileWriter.writeBufferIndex = n3 + 3;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            n3 = classFileWriter.ensureWriteBufferCapacity(3);
            c = cArray[n2];
            if ('\u0001' <= c && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c == '\u0000' || '\u0080' <= c && c <= '\u07ff') {
                byArray[n3 + 1] = (byte)(128 + (c & 0x3F));
                byArray[n3] = (byte)(192 + (c >> 6 & 0x1F));
                n3 += 2;
            } else {
                byArray[n3 + 2] = (byte)(128 + (c & 0x3F));
                byArray[n3 + 1] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n3] = (byte)(224 + (c >> 12 & 0xF));
                n3 += 3;
            }
            classFileWriter.writeBufferIndex = n3;
        }
        return 0;
    }

    public int hashCode() {
        if (!$assertionsDisabled && this.string == null) {
            throw new AssertionError();
        }
        if (this.hash == 0) {
            this.hash = Identifier.hashCode(this.string);
        }
        return this.hash;
    }

    static {
        $assertionsDisabled = !ConstantPoolUtf8.class.desiredAssertionStatus();
    }
}

