/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;

final class ConstantPoolDouble
extends ConstantPoolEntry {
    ConstantPoolDouble nextHashed;
    long bits;

    ConstantPoolDouble(long l) {
        super((byte)6);
        this.bits = l;
    }

    int write(ClassFileWriter classFileWriter) throws IOException {
        int n = classFileWriter.ensureWriteBufferCapacity(9);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n + 8] = (byte)this.bits;
        byArray[n + 7] = (byte)(this.bits >> 8);
        byArray[n + 6] = (byte)(this.bits >> 16);
        byArray[n + 5] = (byte)(this.bits >> 24);
        byArray[n + 4] = (byte)(this.bits >> 32);
        byArray[n + 3] = (byte)(this.bits >> 40);
        byArray[n + 2] = (byte)(this.bits >> 48);
        byArray[n + 1] = (byte)(this.bits >> 56);
        byArray[n] = 6;
        classFileWriter.writeBufferIndex = n + 9;
        return 1;
    }

    static int hashCode(long l) {
        return (int)l + (int)(l >> 32);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ConstantPoolDouble.hashCode(this.bits);
        }
        return this.hash;
    }
}

