/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.Set;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

abstract class ClassSymbol
extends ReferenceTypeSymbol {
    ClassSymbol(int n, Identifier identifier, byte by, short s, Annotation annotation) {
        super(n, identifier, by, s, annotation);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    char[] getInternalName() {
        return this.getClassSymbol().getInternalName();
    }

    boolean isErroneous() {
        RawClassSymbol rawClassSymbol = this.getClassSymbol();
        if (rawClassSymbol != null) {
            return rawClassSymbol.isErroneous();
        }
        return false;
    }

    boolean isClass() {
        return true;
    }

    boolean isCompiled() {
        return this.getClassSymbol().isCompiled();
    }

    TypeSymbol eraseType() {
        return this.getClassSymbol();
    }

    boolean isReifiable() {
        return false;
    }

    abstract RawClassSymbol getClassSymbol();

    abstract ClassSymbol getSuperClassSymbol();

    abstract ImplementationList getImplementationList();

    abstract void checkForOutOfPackageInnerClasses(ConstantPool var1, RawClassSymbol var2);

    boolean isSuperclass(ClassSymbol classSymbol) {
        return this.isSuperclass(classSymbol, null);
    }

    boolean isSuperclass(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        do {
            if ((classSymbol = classSymbol.getSuperClassSymbol()) == null) {
                return false;
            }
            if (!(classSymbol instanceof UnresolvedClassSymbol)) continue;
            throw new UnresolvedSuperClassException(classSymbol);
        } while (!classSymbol.equalTo(this, typeSymbol));
        return true;
    }

    ClassScope getClassScope() {
        return this.getClassSymbol().classScope;
    }

    RawClassSymbol getOuterClass() {
        return this.getClassSymbol().getOuterClass();
    }

    RawClassSymbol getTopLevelClass() {
        return this.getClassSymbol().getTopLevelClass();
    }

    boolean implementsInterface(ClassSymbol classSymbol) {
        return this.implementsInterface(classSymbol, null);
    }

    boolean implementsInterface(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        block10: {
            ClassSymbol classSymbol2;
            block9: {
                if (!classSymbol.isTypeParameter()) break block9;
                ClassSymbolList classSymbolList = ((TypeParameterSymbol)classSymbol).interfaceBounds;
                while (classSymbolList != null) {
                    RawClassSymbol rawClassSymbol = classSymbolList.classSymbol.getClassSymbol();
                    if (rawClassSymbol == this || this.implementsInterface(rawClassSymbol, typeSymbol)) {
                        return true;
                    }
                    classSymbolList = classSymbolList.next;
                }
                break block10;
            }
            RawClassSymbol rawClassSymbol = this.getClassSymbol();
            if ((rawClassSymbol.flags & Short.MIN_VALUE) == 0) {
                rawClassSymbol.propagateFlagsFromSuperclasses();
            }
            if ((rawClassSymbol.flags & 0x400) == 0) break block10;
            if (this.isParameterizedClass() && rawClassSymbol.cd.getTypeParameterList() != null && ((ParameterizedClassSymbol)this).typeVariableList == null) {
                classSymbol = classSymbol.getClassSymbol();
            }
            ImplementationList implementationList = this.getImplementationList();
            while (implementationList != null) {
                classSymbol2 = implementationList.interfaceSymbol;
                if (classSymbol2 instanceof UnresolvedClassSymbol) {
                    throw new UnresolvedSuperClassException(classSymbol2);
                }
                if (classSymbol2.equalTo(classSymbol, typeSymbol)) {
                    return true;
                }
                if (classSymbol2.implementsInterface(classSymbol, typeSymbol)) {
                    return true;
                }
                implementationList = implementationList.next;
            }
            for (classSymbol2 = this.getSuperClassSymbol(); classSymbol2 != null; classSymbol2 = classSymbol2.getSuperClassSymbol()) {
                if (!classSymbol2.implementsInterface(classSymbol, typeSymbol)) continue;
                return true;
            }
        }
        return false;
    }

    boolean implementsInterfaceDirectly(ClassSymbol classSymbol) {
        ImplementationList implementationList = this.getImplementationList();
        while (implementationList != null) {
            if (implementationList.interfaceSymbol.equalTo(classSymbol)) {
                return true;
            }
            implementationList = implementationList.next;
        }
        return false;
    }

    ClassSymbol getDirectInterfaceImplementation(ClassSymbol classSymbol) {
        ImplementationList implementationList = this.getImplementationList();
        while (implementationList != null) {
            if (implementationList.interfaceSymbol.equalTo(classSymbol)) {
                return implementationList.interfaceSymbol;
            }
            implementationList = implementationList.next;
        }
        return null;
    }

    boolean implementsInterfaceDirectlyIndirectly(ClassSymbol classSymbol) {
        ImplementationList implementationList = this.getImplementationList();
        while (implementationList != null) {
            if (implementationList.interfaceSymbol.equalTo(classSymbol) || implementationList.interfaceSymbol.implementsInterfaceDirectlyIndirectly(classSymbol)) {
                return true;
            }
            implementationList = implementationList.next;
        }
        return false;
    }

    ClassSymbol getInterface(RawClassSymbol rawClassSymbol) {
        ClassSymbol classSymbol = this;
        do {
            ImplementationList implementationList = classSymbol.getImplementationList();
            while (implementationList != null) {
                if (implementationList.interfaceSymbol.getClassSymbol() == rawClassSymbol) {
                    return implementationList.interfaceSymbol;
                }
                ClassSymbol classSymbol2 = implementationList.interfaceSymbol.getInterface(rawClassSymbol);
                if (classSymbol2 != null) {
                    return classSymbol2;
                }
                implementationList = implementationList.next;
            }
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        return null;
    }

    static boolean compareArgumentSignatures(MethodSymbol methodSymbol, MethodSymbol methodSymbol2) {
        int n;
        char[] cArray = methodSymbol.getSignature();
        char[] cArray2 = methodSymbol2.getSignature();
        int n2 = Identifier.lastIndexOf(cArray, ')');
        if (n2 != (n = Identifier.lastIndexOf(cArray2, ')'))) {
            return false;
        }
        return Identifier.compare(cArray, 0, cArray2, 0, n2);
    }

    protected boolean compareMethods(MethodSymbol methodSymbol, ClassSymbol classSymbol, MethodSymbol methodSymbol2) {
        if (methodSymbol.identifier != methodSymbol2.identifier) {
            return false;
        }
        if (methodSymbol.argCount != methodSymbol2.argCount) {
            return false;
        }
        RawClassSymbol rawClassSymbol = this.getClassSymbol();
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        ArgumentVariableList argumentVariableList2 = methodSymbol2.argumentList;
        TypeParameterList typeParameterList = null;
        TypeVariableList typeVariableList = null;
        if (classSymbol.isParameterizedClass()) {
            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
            typeVariableList = parameterizedClassSymbol.typeVariableList;
            if (typeVariableList != null) {
                typeParameterList = parameterizedClassSymbol.genericClassSymbol.cd.getTypeParameterList();
            }
        }
        TypeParameterList typeParameterList2 = methodSymbol.typeParameterList;
        TypeParameterList typeParameterList3 = methodSymbol2.typeParameterList;
        if (typeParameterList2 != null && typeParameterList3 != null) {
            do {
                if (!typeParameterList2.typeParameter.bound.equalTo(typeParameterList3.typeParameter.bound)) {
                    return false;
                }
                typeParameterList2 = typeParameterList2.next;
                typeParameterList3 = typeParameterList3.next;
            } while (typeParameterList2 != null && typeParameterList3 != null);
            if (typeParameterList2 != typeParameterList3) {
                return false;
            }
        }
        while (argumentVariableList != null && argumentVariableList2 != null) {
            TypeSymbol typeSymbol;
            TypeSymbol typeSymbol2 = argumentVariableList.argSymbol.type.replaceTypeParameters(rawClassSymbol, typeParameterList, typeVariableList, null);
            if (typeSymbol2.isTypeParameter()) {
                typeSymbol2 = ((TypeParameterSymbol)typeSymbol2).bound;
            }
            if ((typeSymbol = argumentVariableList2.argSymbol.type.replaceTypeParameters(rawClassSymbol, typeParameterList, typeVariableList, null)).isTypeParameter()) {
                typeSymbol = ((TypeParameterSymbol)typeSymbol).bound;
            }
            if (!typeSymbol.equalTo(typeSymbol2)) {
                return false;
            }
            argumentVariableList = argumentVariableList.next;
            argumentVariableList2 = argumentVariableList2.next;
        }
        return argumentVariableList == argumentVariableList2;
    }

    boolean mergeIntoMethodTable(Parser parser, ArrayList arrayList, ParameterizedClassSymbol parameterizedClassSymbol) {
        if (this.isErroneous() || parameterizedClassSymbol.isErroneous()) {
            return false;
        }
        RawClassSymbol rawClassSymbol = parameterizedClassSymbol.getClassSymbol();
        if (rawClassSymbol.cd.methodTable == null) {
            rawClassSymbol.buildMethodTable(parser);
        }
        SourceFile sourceFile = parser.sourceFile;
        RawClassSymbol rawClassSymbol2 = this.getClassSymbol();
        if (rawClassSymbol2.cd.ccd != null) {
            parser.sourceFile = rawClassSymbol2.cd.ccd.sourceFile;
        }
        MethodSymbol[] methodSymbolArray = rawClassSymbol.getMethodTable(parser);
        boolean bl = false;
        Object object = null;
        if (rawClassSymbol2.isCompiled()) {
            object = parser.saveResolutionState(rawClassSymbol2);
        }
        int n = methodSymbolArray.length;
        block0: while (--n >= 0) {
            MethodSymbol methodSymbol = methodSymbolArray[n];
            if (methodSymbol.isConstructor() || methodSymbol.isClassInitializer() || methodSymbol.isSynthetic()) continue;
            if (this.isInterface() && rawClassSymbol == parser.javaLangObjectSymbol) {
                if ((methodSymbol.access & 1) == 0) {
                    continue;
                }
            } else if (!methodSymbol.isAccessible(this, this)) {
                if ((methodSymbol.access & 0x400) == 0) continue;
                arrayList.add(methodSymbol);
                continue;
            }
            int n2 = arrayList.size();
            while (--n2 >= 0) {
                MethodSymbol methodSymbol2 = (MethodSymbol)arrayList.get(n2);
                if (methodSymbol2 == methodSymbol) continue block0;
                int n3 = rawClassSymbol2.pos;
                if (methodSymbol2.definingClass == rawClassSymbol2) {
                    n3 = methodSymbol2.pos;
                }
                if (methodSymbol2.isBridgeMethod()) continue;
                if (this.compareMethods(methodSymbol2, parameterizedClassSymbol, methodSymbol)) {
                    if (parser.options.sourceJDKVersion >= 150 && !ClassSymbol.compareArgumentSignatures(methodSymbol, methodSymbol2)) {
                        if (rawClassSymbol2.isCompiled() && methodSymbol2.definingClass == methodSymbol.definingClass) {
                            parser.error(Message.errorDuplicateDefinition, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName());
                        }
                        if (!methodSymbol.definingClass.isInterface()) {
                            MethodSymbol methodSymbol3 = (MethodSymbol)this.getClassSymbol().classScope.lookupSpecificSymbolInScope(methodSymbol2.identifier, 8, true);
                            while (methodSymbol3 != null && !this.compareMethods(methodSymbol3, parameterizedClassSymbol, methodSymbol)) {
                                methodSymbol3 = methodSymbol3.nextWithSameName;
                            }
                            if (methodSymbol3 == null) {
                                arrayList.add(methodSymbol);
                                continue block0;
                            }
                            methodSymbol2 = methodSymbol3;
                        }
                    }
                    if (!rawClassSymbol2.isCompiled()) continue block0;
                    if ((methodSymbol.access & 8) != (methodSymbol2.access & 8)) {
                        if ((methodSymbol.access & 8) != 0) {
                            parser.error(Message.errorCannotBeOverridden, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), "static " + methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName());
                        } else {
                            parser.error(parameterizedClassSymbol.isInterface() ? Message.errorCannotImplement : Message.errorCannotOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), methodSymbol.resultType.errorName());
                        }
                    }
                    if (parameterizedClassSymbol.equalTo(this.getSuperClassSymbol()) && (methodSymbol.access & 0x10) != 0) {
                        parser.error(Message.errorCannotBeOverridden, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), "final " + methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName());
                    }
                    TypeParameterList typeParameterList = null;
                    TypeVariableList typeVariableList = parameterizedClassSymbol.typeVariableList;
                    if (typeVariableList != null) {
                        typeParameterList = parameterizedClassSymbol.genericClassSymbol.cd.getTypeParameterList();
                    }
                    TypeSymbol typeSymbol = methodSymbol2.resultType.replaceTypeParameters(rawClassSymbol2, typeParameterList, typeVariableList, null);
                    TypeSymbol typeSymbol2 = methodSymbol.resultType.replaceTypeParameters(rawClassSymbol2, typeParameterList, typeVariableList, null);
                    if (typeVariableList != null && typeSymbol2.isTypeParameter() && typeSymbol != typeSymbol2) {
                        parser.error(parameterizedClassSymbol.isInterface() ? Message.errorDifferentReturnImplement : Message.errorDifferentReturnOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), typeSymbol2.errorName());
                    } else if (!typeSymbol2.equalTo(typeSymbol)) {
                        if (parser.options.sourceJDKVersion < 150 || !typeSymbol2.isReferenceType() || !typeSymbol.isReferenceType()) {
                            parser.error(parameterizedClassSymbol.isInterface() ? Message.errorDifferentReturnImplement : Message.errorDifferentReturnOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), typeSymbol2.errorName());
                        } else {
                            ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol2;
                            ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol;
                            boolean bl2 = false;
                            if (methodSymbol2.definingClass == rawClassSymbol2) {
                                if (!referenceTypeSymbol.isReturnSubstitutable(parser, referenceTypeSymbol2)) {
                                    bl2 = true;
                                }
                            } else if (!referenceTypeSymbol.isReturnSubstitutable(parser, referenceTypeSymbol2) && !referenceTypeSymbol2.isReturnSubstitutable(parser, referenceTypeSymbol)) {
                                bl2 = true;
                            }
                            if (bl2) {
                                parser.error(parameterizedClassSymbol.isInterface() ? Message.errorDifferentReturnImplement : Message.errorDifferentReturnOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), typeSymbol2.errorName());
                            } else {
                                bl = true;
                            }
                        }
                    }
                    MethodSymbol.ThrowsList throwsList = methodSymbol2.throwsList;
                    while (throwsList != null) {
                        block45: {
                            if (!throwsList.throwsType.isErroneous()) {
                                ClassSymbol classSymbol = (ClassSymbol)throwsList.throwsType;
                                if (classSymbol.isTypeParameter()) {
                                    classSymbol = ((TypeParameterSymbol)classSymbol).bound;
                                }
                                if ((parser.javaLangExceptionSymbol.equalTo(classSymbol) || parser.javaLangExceptionSymbol.isSuperclass(classSymbol)) && !parser.javaLangRuntimeExceptionSymbol.equalTo(classSymbol) && !parser.javaLangRuntimeExceptionSymbol.isSuperclass(classSymbol)) {
                                    MethodSymbol.ThrowsList throwsList2 = methodSymbol.throwsList;
                                    while (throwsList2 != null) {
                                        if (!throwsList2.throwsType.isErroneous()) {
                                            ClassSymbol classSymbol2 = (ClassSymbol)throwsList2.throwsType;
                                            if (classSymbol2.isTypeParameter()) {
                                                classSymbol2 = ((TypeParameterSymbol)classSymbol2).bound;
                                            }
                                            if (classSymbol.equalTo(classSymbol2) || classSymbol2.isSuperclass(classSymbol)) break block45;
                                        }
                                        throwsList2 = throwsList2.next;
                                    }
                                    if (!methodSymbol2.definingClass.isInterface() || !methodSymbol.definingClass.isInterface()) {
                                        parser.error(parameterizedClassSymbol.isInterface() ? Message.errorMoreThrowsImplement : Message.errorMoreThrowsOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), classSymbol.errorName());
                                    }
                                }
                            }
                        }
                        throwsList = throwsList.next;
                    }
                    if (ClassSymbol.getAccessStrength(methodSymbol.access) > ClassSymbol.getAccessStrength(methodSymbol2.access)) {
                        parser.error(parameterizedClassSymbol.isInterface() ? Message.errorWeakerAccessImplement : Message.errorWeakerAccessOverride, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName(), methodSymbol.errorName() + " " + Message.inString + " " + methodSymbol.definingClass.errorName(), ClassSymbol.accessToString((short)(methodSymbol.access & 7)));
                    }
                    if (!methodSymbol.isDeprecated() || methodSymbol2.isDeprecated()) continue block0;
                    parser.warning(this, Message.warningOverridesDeprecated, n3, methodSymbol.errorName(), parameterizedClassSymbol.isInterface() ? Message.implementedString : Message.overriddenString, Message.methodString);
                    continue block0;
                }
                if (parser.options.sourceJDKVersion < 150 || methodSymbol2.identifier != methodSymbol.identifier || !ClassSymbol.compareArgumentSignatures(methodSymbol, methodSymbol2)) continue;
                parser.error(Message.errorDuplicateDefinition, n3, methodSymbol.isErroneous() | methodSymbol2.isErroneous(), methodSymbol2.errorName() + " " + Message.inString + " " + methodSymbol2.definingClass.errorName());
            }
            arrayList.add(methodSymbol);
        }
        if (rawClassSymbol2.isCompiled()) {
            parser.restoreResolutionState(object);
        }
        parser.sourceFile = sourceFile;
        return bl;
    }

    void getSuperclasses(Set set) {
        ClassSymbol classSymbol = this;
        if (classSymbol.isInterface()) {
            set.add(classSymbol.getSuperClassSymbol());
            ImplementationList implementationList = classSymbol.getImplementationList();
            while (implementationList != null) {
                set.add(implementationList.interfaceSymbol);
                implementationList.interfaceSymbol.getSuperclasses(set);
                implementationList = implementationList.next;
            }
        }
        while ((classSymbol = classSymbol.getSuperClassSymbol()) != null) {
            set.add(classSymbol);
        }
    }

    void getErasedSuperclasses(Set set) {
        ClassSymbol classSymbol = this;
        if (classSymbol.isInterface()) {
            set.add(classSymbol.getSuperClassSymbol().getClassSymbol());
            ImplementationList implementationList = classSymbol.getImplementationList();
            while (implementationList != null) {
                set.add(implementationList.interfaceSymbol.getClassSymbol());
                implementationList.interfaceSymbol.getErasedSuperclasses(set);
                implementationList = implementationList.next;
            }
        }
        while ((classSymbol = classSymbol.getSuperClassSymbol()) != null) {
            set.add(classSymbol.getClassSymbol());
        }
    }
}

