/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class CharConstantExpression
extends ConstantExpression {
    char cval;

    CharConstantExpression(int n, char c) {
        super(n, TypeSymbol.charSymbol);
        this.cval = c;
    }

    Expression copyConstantExpression() {
        return new CharConstantExpression(this.pos, this.cval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generateIntConst(this.cval);
        byteCodeGenerator.incOpStackHeight(1);
    }

    int getIntConstValue() {
        return this.cval;
    }
}

