/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class CastExpression
extends UnaryExpression {
    TypeSymbol castType;
    static final /* synthetic */ boolean $assertionsDisabled;

    CastExpression(int n, Expression expression, TypeSymbol typeSymbol) {
        super((byte)46, n, expression);
        this.castType = typeSymbol;
    }

    static Expression castNumericConstant(Expression expression, TypeSymbol typeSymbol, boolean bl) {
        if (!$assertionsDisabled && expression.kind != 2) {
            throw new AssertionError();
        }
        TypeSymbol typeSymbol2 = expression.getType();
        if (!($assertionsDisabled || typeSymbol.isNumericType() && typeSymbol2.isNumericType())) {
            throw new AssertionError();
        }
        byte by = typeSymbol.typeKind;
        byte by2 = typeSymbol2.typeKind;
        switch (by2) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                CharConstantExpression charConstantExpression = (CharConstantExpression)expression;
                char c = charConstantExpression.cval;
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.byteSymbol, (byte)c);
                    }
                    case 4: {
                        if (bl) {
                            return new CharConstantExpression(expression.pos, c);
                        }
                        return charConstantExpression;
                    }
                    case 5: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.shortSymbol, (short)c);
                    }
                    case 6: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.intSymbol, c);
                    }
                    case 7: {
                        return new LongConstantExpression(expression.pos, (long)c);
                    }
                    case 8: {
                        return new FloatConstantExpression(expression.pos, (float)c);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(expression.pos, (double)c);
            }
            case 3: 
            case 5: 
            case 6: {
                IntConstantExpression intConstantExpression = (IntConstantExpression)expression;
                int n = intConstantExpression.ival;
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        if (bl) {
                            return new IntConstantExpression(expression.pos, TypeSymbol.byteSymbol, n);
                        }
                        intConstantExpression.ival = (byte)n;
                        intConstantExpression.setType(TypeSymbol.byteSymbol);
                        return intConstantExpression;
                    }
                    case 4: {
                        return new CharConstantExpression(expression.pos, (char)n);
                    }
                    case 5: {
                        if (bl) {
                            return new IntConstantExpression(expression.pos, TypeSymbol.shortSymbol, n);
                        }
                        intConstantExpression.ival = (short)n;
                        intConstantExpression.setType(TypeSymbol.shortSymbol);
                        return intConstantExpression;
                    }
                    case 6: {
                        if (bl) {
                            return new IntConstantExpression(expression.pos, TypeSymbol.intSymbol, n);
                        }
                        intConstantExpression.setType(TypeSymbol.intSymbol);
                        return intConstantExpression;
                    }
                    case 7: {
                        return new LongConstantExpression(expression.pos, (long)n);
                    }
                    case 8: {
                        return new FloatConstantExpression(expression.pos, (float)n);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(expression.pos, (double)n);
            }
            case 7: {
                LongConstantExpression longConstantExpression = (LongConstantExpression)expression;
                long l = longConstantExpression.lval;
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.byteSymbol, (byte)l);
                    }
                    case 4: {
                        return new CharConstantExpression(expression.pos, (char)l);
                    }
                    case 5: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.shortSymbol, (short)l);
                    }
                    case 6: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.intSymbol, (int)l);
                    }
                    case 7: {
                        if (bl) {
                            return new LongConstantExpression(expression.pos, l);
                        }
                        return longConstantExpression;
                    }
                    case 8: {
                        return new FloatConstantExpression(expression.pos, l);
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(expression.pos, l);
            }
            case 8: {
                FloatConstantExpression floatConstantExpression = (FloatConstantExpression)expression;
                float f = floatConstantExpression.fval;
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.byteSymbol, (byte)f);
                    }
                    case 4: {
                        return new CharConstantExpression(expression.pos, (char)f);
                    }
                    case 5: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.shortSymbol, (short)f);
                    }
                    case 6: {
                        return new IntConstantExpression(expression.pos, TypeSymbol.intSymbol, (int)f);
                    }
                    case 7: {
                        return new LongConstantExpression(expression.pos, (long)f);
                    }
                    case 8: {
                        if (bl) {
                            return new FloatConstantExpression(expression.pos, f);
                        }
                        return floatConstantExpression;
                    }
                    case 9: 
                }
                return new DoubleConstantExpression(expression.pos, f);
            }
            case 9: 
        }
        DoubleConstantExpression doubleConstantExpression = (DoubleConstantExpression)expression;
        double d = doubleConstantExpression.dval;
        switch (by) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 3: {
                return new IntConstantExpression(expression.pos, TypeSymbol.byteSymbol, (byte)d);
            }
            case 4: {
                return new CharConstantExpression(expression.pos, (char)d);
            }
            case 5: {
                return new IntConstantExpression(expression.pos, TypeSymbol.shortSymbol, (short)d);
            }
            case 6: {
                return new IntConstantExpression(expression.pos, TypeSymbol.intSymbol, (int)d);
            }
            case 7: {
                return new LongConstantExpression(expression.pos, (long)d);
            }
            case 8: {
                return new FloatConstantExpression(expression.pos, (float)d);
            }
            case 9: 
        }
        if (bl) {
            return new DoubleConstantExpression(expression.pos, d);
        }
        return doubleConstantExpression;
    }

    Expression foldExpression() {
        TypeSymbol typeSymbol = this.getType();
        if (typeSymbol.isNumericType()) {
            Expression expression = this.operand;
            if (expression.kind == 2) {
                return CastExpression.castNumericConstant(expression, typeSymbol, false);
            }
        }
        return this;
    }

    Expression constantFolding() {
        this.operand = this.operand.constantFolding();
        return this.foldExpression();
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.operand.resolveAndCheck(parser);
        if (expression instanceof ErrorExpression) {
            return expression;
        }
        TypeSymbol typeSymbol = this.castType.resolveType(parser, this.pos, false, true, false);
        if (typeSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        TypeSymbol typeSymbol2 = expression.getType();
        if (typeSymbol2.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        if (typeSymbol2 == typeSymbol) {
            parser.warning(typeSymbol2, Message.warningUnnecessaryCast, this.pos, typeSymbol2.errorName(), typeSymbol.errorName());
            return expression;
        }
        typeSymbol.checkDeprecated(parser, this.pos);
        byte by = typeSymbol.typeKind;
        switch (by) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (typeSymbol2.isPrimitiveType()) {
                    TypeSymbol typeSymbol3;
                    if (parser.options.sourceJDKVersion >= 150 && (typeSymbol3 = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null && (typeSymbol3.typeKind == typeSymbol2.typeKind || typeSymbol3.isNumericType() && typeSymbol2.isNumericType() || typeSymbol.equalTo(parser.javaLangNumberSymbol) || typeSymbol.equalTo(parser.javaLangObjectSymbol))) {
                        return new AutoBoxingExpression(expression, typeSymbol);
                    }
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (!typeSymbol.isTypeParameter() && typeSymbol.equalTo(parser.javaLangObjectSymbol)) {
                    parser.warning(typeSymbol, Message.warningUnnecessaryCast, this.pos, typeSymbol2.errorName(), typeSymbol.errorName());
                    break;
                }
                ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol2;
                ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol;
                if (!referenceTypeSymbol.isCastCompatible(parser, referenceTypeSymbol2)) {
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                typeSymbol.checkUncheckConversion(parser, this.pos, typeSymbol2, true);
                break;
            }
            case 2: {
                TypeSymbol typeSymbol4;
                if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol4 = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && typeSymbol4.typeKind == 2) {
                    return new AutoUnboxingExpression(expression, typeSymbol4);
                }
                Error error = parser.error(Message.errorCannotCast, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (!typeSymbol2.isNumericType()) {
                    TypeSymbol typeSymbol5;
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol5 = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && typeSymbol5.isNumericType()) {
                        expression = new AutoUnboxingExpression(expression, typeSymbol5);
                        if (typeSymbol5 != typeSymbol) break;
                        return expression;
                    }
                    Error error = parser.error(Message.errorCannotCast, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                if (expression.kind != 2) break;
                return CastExpression.castNumericConstant(expression, typeSymbol, false);
            }
        }
        this.setType(typeSymbol);
        this.operand = expression;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.operand;
        expression.generateByteCode(byteCodeGenerator);
        TypeSymbol typeSymbol = this.getType();
        byte by = typeSymbol.typeKind;
        TypeSymbol typeSymbol2 = expression.getType();
        byte by2 = typeSymbol2.typeKind;
        block0 : switch (by) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (typeSymbol == ReferenceTypeSymbol.nullTypeSymbol) break;
                if (typeSymbol.isClass()) {
                    RawClassSymbol rawClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                    byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, rawClassSymbol);
                }
                short s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                byteCodeGenerator.generate_8_16((byte)-64, s);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (by2) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-120);
                        byteCodeGenerator.decOpStackHeight(1);
                        break;
                    }
                    case 8: {
                        byteCodeGenerator.generate_8((byte)-117);
                        break;
                    }
                    case 9: {
                        byteCodeGenerator.generate_8((byte)-114);
                        byteCodeGenerator.decOpStackHeight(1);
                    }
                }
                if (by == 3) {
                    byteCodeGenerator.generate_8((byte)-111);
                    break;
                }
                if (by == 5) {
                    byteCodeGenerator.generate_8((byte)-109);
                    break;
                }
                if (by != 4) break;
                byteCodeGenerator.generate_8((byte)-110);
                break;
            }
            case 7: {
                switch (by2) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-123);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 8: {
                        byteCodeGenerator.generate_8((byte)-116);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 9: 
                }
                byteCodeGenerator.generate_8((byte)-113);
                break;
            }
            case 8: {
                switch (by2) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-122);
                        break block0;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-119);
                        byteCodeGenerator.decOpStackHeight(1);
                        break block0;
                    }
                    case 9: 
                }
                byteCodeGenerator.generate_8((byte)-112);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 9: {
                switch (by2) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        byteCodeGenerator.generate_8((byte)-121);
                        byteCodeGenerator.incOpStackHeight(1);
                        break block0;
                    }
                    case 7: {
                        byteCodeGenerator.generate_8((byte)-118);
                        break block0;
                    }
                    case 8: 
                }
                byteCodeGenerator.generate_8((byte)-115);
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
    }

    static {
        $assertionsDisabled = !CastExpression.class.desiredAssertionStatus();
    }
}

