/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.LocalScope;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class BlockScope
extends LocalScope {
    static final /* synthetic */ boolean $assertionsDisabled;

    BlockScope(Scope scope, Parser parser) {
        super((byte)4, 0, parser);
        this.outerScope = scope;
    }

    void removeSymbol(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.symbolTable;
        if (symbol2 == symbol) {
            this.symbolTable = symbol.nextHashed;
        } else {
            while (true) {
                Symbol symbol3 = symbol2.nextHashed;
                if (!$assertionsDisabled && symbol3 == null) {
                    throw new AssertionError();
                }
                if (symbol3 == symbol) {
                    symbol2.nextHashed = symbol.nextHashed;
                    break;
                }
                symbol2 = symbol3;
            }
        }
    }

    void enterSymbol(Symbol symbol) {
        if (!$assertionsDisabled && (symbol instanceof UnresolvedSymbol || symbol instanceof UnresolvedClassSymbol)) {
            throw new AssertionError();
        }
        symbol.scope = this;
        symbol.nextHashed = (Symbol)this.symbolTable;
        this.symbolTable = symbol;
        if (this.declList != null && symbol.kind != -128) {
            this.declList.add(symbol);
        }
    }

    Symbol lookupSymbolInScope(Identifier identifier, boolean bl) {
        Symbol symbol = (Symbol)this.symbolTable;
        while (symbol != null) {
            if (identifier == symbol.identifier) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol lookupSpecificSymbolInScope(Identifier identifier, int n, boolean bl) {
        Symbol symbol = (Symbol)this.symbolTable;
        while (symbol != null) {
            if ((symbol.kind & n) != 0 && identifier == symbol.identifier) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol lookupSpecificSymbol(Identifier identifier, int n, boolean bl) {
        Symbol symbol = this.lookupSpecificSymbolInScope(identifier, n, bl);
        if (symbol != null) {
            return symbol;
        }
        return this.outerScope.lookupSpecificSymbol(identifier, n, bl);
    }

    Symbol[] getSymbols() {
        int n = 0;
        Symbol symbol = (Symbol)this.symbolTable;
        while (symbol != null) {
            symbol = symbol.nextHashed;
            ++n;
        }
        Symbol[] symbolArray = new Symbol[n];
        int n2 = 0;
        symbol = (Symbol)this.symbolTable;
        while (symbol != null) {
            symbolArray[n2] = symbol;
            symbol = symbol.nextHashed;
            ++n2;
        }
        return symbolArray;
    }

    String errorName() {
        return this.outerScope.errorName();
    }

    static {
        $assertionsDisabled = !BlockScope.class.desiredAssertionStatus();
    }
}

