/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class BitExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    BitExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand.resolveAndCheck(parser);
        Expression expression2 = this.rightOperand.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        TypeSymbol typeSymbol3 = expression2.getType();
        if (typeSymbol2.typeKind == 2 && typeSymbol3.typeKind == 2) {
            typeSymbol = TypeSymbol.booleanSymbol;
            this.setType(typeSymbol);
        } else {
            typeSymbol = TypeSymbol.binaryNumericPromotion(parser, typeSymbol2, typeSymbol3);
            this.setType(typeSymbol);
            if (typeSymbol.isErroneous() || (typeSymbol.typeClass & 0x30) != 0) {
                if (parser.options.sourceJDKVersion >= 150 && (typeSymbol2.equalTo(parser.javaLangBooleanSymbol) || typeSymbol2 == TypeSymbol.booleanSymbol) && (typeSymbol3.equalTo(parser.javaLangBooleanSymbol) || typeSymbol3 == TypeSymbol.booleanSymbol)) {
                    typeSymbol = TypeSymbol.booleanSymbol;
                    this.setType(typeSymbol);
                } else {
                    Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol3.isErroneous() | typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName() + " " + Message.andString + " " + typeSymbol3.errorName());
                    return new ErrorExpression(error);
                }
            }
        }
        this.leftOperand = expression.promoteType(parser, typeSymbol);
        this.rightOperand = expression2.promoteType(parser, typeSymbol);
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte by, byte by2) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: 
            case 4: {
                byteCodeGenerator.generate_8(by);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(by2);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
    }

    static {
        $assertionsDisabled = !BitExpression.class.desiredAssertionStatus();
    }
}

