/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AppendStringExpression;
import oracle.ojc.compiler.AssignmentOperationExpression;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class AssignmentPlusExpression
extends AssignmentOperationExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentPlusExpression(int n, Expression expression, Expression expression2) {
        super((byte)6, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.leftOperand;
        byte by = expression.kind;
        if (by != 1 && by != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, expression.pos, by == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        expression = expression.resolveAndCheckReadBeforeWrite(parser);
        by = expression.kind;
        if (by != 1 && by != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, by == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        RawClassSymbol rawClassSymbol = parser.javaLangStringSymbol;
        TypeSymbol typeSymbol = expression.getType();
        if (typeSymbol.equalTo(rawClassSymbol)) {
            if (expression2.getType().typeKind == 1) {
                Error error = parser.error(Message.errorTypeNotAllowed, this.pos, false, TypeSymbol.voidSymbol.errorName());
                return new ErrorExpression(error);
            }
            if (expression2.kind != 51) {
                expression2 = new AppendStringExpression(parser, expression2);
            }
        } else {
            TypeSymbol typeSymbol2 = expression2.getType();
            TypeSymbol typeSymbol3 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol2);
            if (typeSymbol3.isErroneous()) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous() | typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                return new ErrorExpression(error);
            }
        }
        this.setType(typeSymbol);
        this.leftOperand = expression;
        this.rightOperand = expression2;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.leftOperand;
        TypeSymbol typeSymbol = expression.getType();
        Parser parser = byteCodeGenerator.parser;
        if (typeSymbol.equalTo(parser.javaLangStringSymbol)) {
            char[] cArray;
            char[] cArray2;
            ConstantPool constantPool = byteCodeGenerator.constantPool;
            boolean bl = byteCodeGenerator.doingStringConcatonation;
            byteCodeGenerator.doingStringConcatonation = true;
            if (parser.options.targetJDKVersion < 150) {
                cArray2 = Identifier.javaLangStringBufferInternal.name;
                cArray = Identifier.javaLangStringBufferMethodStringSignature.name;
            } else {
                cArray2 = Identifier.javaLangStringBuilderInternal.name;
                cArray = Identifier.javaLangStringBuilderMethodStringSignature.name;
            }
            short s = constantPool.enterConstantPoolClass(cArray2);
            byteCodeGenerator.generate_8_16((byte)-69, s);
            byteCodeGenerator.generate_8((byte)89);
            byteCodeGenerator.incOpStackHeight(2);
            s = constantPool.enterConstantPoolMethodRef(cArray2, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-73, s);
            byteCodeGenerator.decOpStackHeight(1);
            s = constantPool.enterConstantPoolMethodRef(cArray2, Identifier.appendIdentifier.name, cArray);
            expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, true);
            byteCodeGenerator.generate_8_16((byte)-74, s);
            byteCodeGenerator.decOpStackHeight(1);
            this.rightOperand.generateByteCode(byteCodeGenerator);
            s = constantPool.enterConstantPoolMethodRef(cArray2, Identifier.toStringIdentifier.name, Identifier.javaLangStringMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-74, s);
            byteCodeGenerator.doingStringConcatonation = bl;
        } else {
            expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
            TypeSymbol typeSymbol2 = null;
            if (typeSymbol.isReferenceType()) {
                typeSymbol2 = BoxingExpression.getPrimitiveType(parser, typeSymbol);
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol, typeSymbol2);
                typeSymbol = typeSymbol2;
            }
            Expression expression2 = this.rightOperand;
            TypeSymbol typeSymbol3 = expression2.getType();
            TypeSymbol typeSymbol4 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol3);
            byte by = typeSymbol4.typeClass;
            byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol.typeClass, by);
            expression2.generateByteCode(byteCodeGenerator);
            if (typeSymbol3.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol3, typeSymbol);
            }
            byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol3.typeClass, by);
            switch (by) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8((byte)96);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)97);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)98);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)99);
                    byteCodeGenerator.decOpStackHeight(2);
                }
            }
            byteCodeGenerator.generateNarrowingPrimitiveConversion(by, typeSymbol.typeKind);
            if (typeSymbol2 != null) {
                AutoBoxingExpression.generateByteCode(byteCodeGenerator, typeSymbol2, expression.getType());
            }
        }
        if (this.getType().typeKind != 1) {
            if ((expression.getType().typeClass & 0x28) != 0) {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        expression.generateByteCodeWrite(byteCodeGenerator);
    }

    public String toString() {
        return "+=";
    }

    static {
        $assertionsDisabled = !AssignmentPlusExpression.class.desiredAssertionStatus();
    }
}

