/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;

final class ArrayElementValue
extends ElementValue {
    ArrayList arrayElements;

    ArrayElementValue(Identifier identifier, ArrayList arrayList, int n, boolean bl, boolean bl2) {
        super(identifier, n, bl, bl2);
        this.arrayElements = arrayList;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        super.resolveAndCheck(parser, annotation);
        RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
        if (!this.typeSymbol.isArrayType()) {
            parser.error(Message.errorArrayRequired, this.pos, this.typeSymbol.isErroneous(), this.typeSymbol.errorName());
            rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x10);
        } else {
            int n = this.arrayElements.size();
            while (--n >= 0) {
                ElementValue elementValue = (ElementValue)this.arrayElements.get(n);
                elementValue.resolveAndCheck(parser, annotation);
            }
        }
        return this;
    }

    int getAttributeLength() {
        int n = super.getAttributeLength() + 2;
        int n2 = this.arrayElements.size();
        while (--n2 >= 0) {
            ElementValue elementValue = (ElementValue)this.arrayElements.get(n2);
            n += elementValue.getAttributeLength();
        }
        return n;
    }

    void generateConstantPoolEntries(ClassFileWriter classFileWriter, ConstantPool constantPool) {
        super.generateConstantPoolEntries(classFileWriter, constantPool);
        int n = this.arrayElements.size();
        while (--n >= 0) {
            ElementValue elementValue = (ElementValue)this.arrayElements.get(n);
            elementValue.generateConstantPoolEntries(classFileWriter, constantPool);
        }
        this.tag = (byte)91;
    }

    void write(ClassFileWriter classFileWriter) throws IOException {
        super.write(classFileWriter);
        int n = this.arrayElements.size();
        int n2 = classFileWriter.ensureWriteBufferCapacity(2);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n2 + 1] = (byte)n;
        byArray[n2] = (byte)(n >> 8);
        classFileWriter.writeBufferIndex = n2 + 2;
        for (int i = 0; i < n; ++i) {
            ElementValue elementValue = (ElementValue)this.arrayElements.get(i);
            elementValue.write(classFileWriter);
        }
    }
}

