/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;

final class AnnotationElementValue
extends ElementValue {
    private Annotation annotation;

    AnnotationElementValue(Identifier identifier, Annotation annotation, int n, boolean bl, boolean bl2) {
        super(identifier, n, bl, bl2);
        this.annotation = annotation;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        super.resolveAndCheck(parser, annotation);
        this.annotation.resolveAndCheck(parser, null);
        RawClassSymbol rawClassSymbol = ((ClassSymbol)this.annotation.annotationType).getClassSymbol();
        ElementValue elementValue = this;
        if (this.typeSymbol.isArrayType()) {
            ArrayList<AnnotationElementValue> arrayList = new ArrayList<AnnotationElementValue>(1);
            arrayList.add(this);
            elementValue = new ArrayElementValue(this.elementName, arrayList, this.pos, (this.flags & 1) != 0, false);
            elementValue.typeSymbol = this.typeSymbol;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.flags = (byte)(this.flags | 2);
            this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
        }
        if (!this.annotation.annotationType.equalTo(this.typeSymbol)) {
            parser.error(Message.errorIncompatibleTypes, this.pos, this.annotation.annotationType.isErroneous() | this.typeSymbol.isErroneous(), this.annotation.annotationType.errorName(), this.typeSymbol.errorName());
            rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x10);
        }
        return elementValue;
    }

    int getAttributeLength() {
        return super.getAttributeLength() + this.annotation.getAttributeLength();
    }

    void generateConstantPoolEntries(ClassFileWriter classFileWriter, ConstantPool constantPool) {
        super.generateConstantPoolEntries(classFileWriter, constantPool);
        this.annotation.generateConstantPoolEntries(classFileWriter, constantPool);
        this.tag = (byte)64;
    }

    void write(ClassFileWriter classFileWriter) throws IOException {
        super.write(classFileWriter);
        this.annotation.writeAnnotation(classFileWriter);
    }
}

