/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.types.Path;

public class OjcAdapter
implements CompilerAdapter {
    public static final String UNUSED_IMPORT_WARNINGS = "ojc.unused.import.warnings";
    public static final String PARTIALLY_USED_IMPORT_WARNINGS = "ojc.partially.used.import.warnings";
    public static final String OBFUSCATE = "ojc.obfuscate";
    public static final String QUIET = "ojc.quiet";
    public static final String EXCLUDE_CLASS = "ojc.exclude.class";
    private Javac javac = null;

    public void setJavac(Javac javac) {
        this.javac = javac;
    }

    public boolean execute() {
        File[] fileArray;
        Path path;
        Options options = new Options(null);
        options.log = new AntLog(options);
        options.lineNumbers = true;
        options.sourceFile = true;
        if (this.javac.getDebug()) {
            options.codecoach = true;
            options.localVariables = true;
        }
        Message.initializeMessages(options.log);
        if (this.javac.getNowarn()) {
            Warning.disableAllWarnings();
        } else {
            Warning.defaultAllWarnings();
            if (this.javac.getDeprecation()) {
                Warning.enableWarning(Message.warningIsDeprecated.getNumber());
            }
        }
        options.noquiet = !this.getBoolean(QUIET, !options.noquiet);
        String string = this.javac.getSource();
        if (string != null) {
            if (string.equals("1.1")) {
                options.sourceJDKVersion = 110;
            } else if (string.equals("1.2")) {
                options.sourceJDKVersion = 120;
            } else if (string.equals("1.3")) {
                options.sourceJDKVersion = 130;
            } else if (string.equals("1.4")) {
                options.sourceJDKVersion = 140;
            } else if (string.equals("1.5")) {
                options.sourceJDKVersion = 150;
            }
        }
        if ((path = this.javac.getTarget()) != null) {
            if (path.equals("1.1")) {
                options.targetJDKVersion = 110;
            } else if (path.equals("1.2")) {
                options.targetJDKVersion = 120;
            } else if (path.equals("1.3")) {
                options.targetJDKVersion = 130;
            } else if (path.equals("1.4")) {
                options.targetJDKVersion = 140;
            } else if (path.equals("1.5")) {
                options.targetJDKVersion = 150;
            }
        }
        if ((string = this.javac.getProject().getProperty(EXCLUDE_CLASS)) != null) {
            options.excludeClasses = new ArrayList();
            path = Options.stringToArray(string, File.pathSeparator);
            for (int i = 0; i < ((String[])path).length; ++i) {
                options.excludeClasses.add(path[i]);
            }
        }
        options.verbose = this.javac.getVerbose();
        options.encoding = Options.getEncoding(this.javac.getEncoding());
        path = this.javac.getClasspath();
        Path path2 = this.javac.getBootclasspath();
        if (path2 != null) {
            path2.append(path);
            path = path2;
        }
        if (path != null) {
            path.append(path2);
        }
        if (path != null) {
            options.classpathStr = path.toString();
        } else {
            fileArray = System.getProperty("sun.boot.class.path");
            options.classpathStr = fileArray;
        }
        options.sourcepathStr = this.javac.getSrcdir().toString();
        options.destinationDir = this.javac.getDestdir().getPath();
        fileArray = this.javac.getFileList();
        ArrayList<FileStorage> arrayList = new ArrayList<FileStorage>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(new FileStorage(fileArray[i]));
        }
        Compiler.main(arrayList, options);
        if (options.log.nerrors() > 1) {
            this.javac.log(options.log.nerrors() + " errors");
            return false;
        }
        if (options.log.nerrors() > 0) {
            this.javac.log("1 error");
            return false;
        }
        return true;
    }

    private final boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.javac.getProject().getProperty(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private class AntLog
    implements Log {
        Options options;
        int nerr = 0;
        int nwarn = 0;

        AntLog(Options options) {
            this.options = options;
        }

        public void redirect(String string) {
            System.out.println("AntLog.redirect: not implemented yet: " + string);
        }

        public void print(String string) {
            if (this.options.noquiet) {
                OjcAdapter.this.javac.log(string);
            }
        }

        public void println(String string) {
            if (this.options.noquiet) {
                OjcAdapter.this.javac.log(string);
            }
        }

        public void printError(Storage storage, int n, ErrorInfo errorInfo) {
            OjcAdapter.this.javac.log(this.getMessage(storage, n, errorInfo, true), 0);
            ++this.nerr;
        }

        public void printWarning(Storage storage, int n, ErrorInfo errorInfo) {
            OjcAdapter.this.javac.log(this.getMessage(storage, n, errorInfo, false), 1);
            ++this.nwarn;
        }

        private String getMessage(Storage storage, int n, ErrorInfo errorInfo, boolean bl) {
            String string = (bl ? "error #" : "warning #") + errorInfo.getNumber() + ": " + errorInfo.getMessage();
            String string2 = storage != null ? storage.getPath() + ":" + Scanner.positionToLine(n) + ": " + string : string;
            return string2;
        }

        public int nerrors() {
            return this.nerr;
        }

        public int nwarnings() {
            return this.nwarn;
        }
    }

    private class Env
    implements IdeEnv {
        private Env() {
        }

        public boolean authorizeParsing(Storage storage, String string) {
            return !Thread.currentThread().isInterrupted();
        }

        public boolean authorizeChecking(Storage storage, String string) {
            return !Thread.currentThread().isInterrupted();
        }

        public boolean authorizeWriting(Storage storage, String string, byte[] byArray, int n, int n2) {
            return !Thread.currentThread().isInterrupted();
        }
    }
}

