/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;

public final class SplashScreen
extends Frame {
    private final String fImageId;
    private Image fImage;
    private String version;

    public SplashScreen(String aImageId, String version) {
        if (aImageId == null || aImageId.trim().length() == 0) {
            throw new IllegalArgumentException("Image Id does not have content.");
        }
        this.fImageId = aImageId;
        this.version = version;
    }

    public void splash() {
        this.initImageAndTracker();
        this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null));
        this.center();
        SplashWindow splashWindow = new SplashWindow(this, this.fImage, this.version);
    }

    private void initImageAndTracker() {
        System.out.println(this.fImageId);
        URL imageURL = this.getClass().getResource(this.fImageId);
        try {
            this.fImage = new ImageIcon(imageURL).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public static void main(String[] args) {
        SplashScreen splashScreen = new SplashScreen("../../resource/imagens/splash_mci.jpg", "6.0");
        splashScreen.splash();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            System.out.println(ex);
        }
        System.exit(0);
    }

    private class SplashWindow
    extends Window {
        private Image _fImage;
        private String _version;

        SplashWindow(Frame aParent, Image aImage, String version) {
            super(aParent);
            SplashScreen.this.fImage = aImage;
            this._version = version;
            this.setSize(SplashScreen.this.fImage.getWidth(null), SplashScreen.this.fImage.getHeight(null));
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle window = this.getBounds();
            this.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            if (SplashScreen.this.fImage != null) {
                graphics.drawImage(SplashScreen.this.fImage, 0, 0, this);
                if (this._version != null) {
                    graphics.setColor(Color.BLACK);
                    graphics.drawString(this._version, 310, 155);
                }
            }
        }
    }
}

