/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.swing;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MciNumberField
extends JTextField {
    private int _length = 10;

    public MciNumberField(String mask) {
        this._length = mask.length();
    }

    @Override
    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            StringBuffer buffer = new StringBuffer();
            boolean number = true;
            if (str == null) {
                return;
            }
            char[] upper = str.toCharArray();
            for (int i = 0; i < upper.length; ++i) {
                if (Character.isDigit(upper[i])) {
                    buffer.append(upper[i]);
                    continue;
                }
                number = false;
            }
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= MciNumberField.this._length) {
                if (number) {
                    super.insertString(offs, buffer.toString(), a);
                }
            } else {
                if (this.getLength() == MciNumberField.this._length) {
                    return;
                }
                String newStr = buffer.toString().substring(0, MciNumberField.this._length - this.getLength());
                if (number) {
                    super.insertString(offs, newStr, a);
                }
            }
        }
    }
}

