/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.swing;

import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.swing.MciAbstractField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MciFoneField
extends MciAbstractField {
    private static final long serialVersionUID = 1L;
    private String _maskFormat = null;
    private String _errorMessage = null;
    private MaskFormatter _foneFormat = null;
    private static Log log = LogFactory.getLog(MciFoneField.class);

    public MciFoneField(String mask) {
        this(mask, null);
    }

    public MciFoneField(String mask, String errorMessage) {
        super(new MaskFormatter());
        this.addFocusListener(new FoneFocusListener());
        if (mask == null) {
            mask = this._maskFormat;
        }
        this._errorMessage = errorMessage;
        this.setMaskEdit((MaskFormatter)this.getFormatter());
        try {
            this.setFoneFormat(new MaskFormatter(mask));
        }
        catch (ParseException e) {
            log.error((Object)e.toString());
        }
        this.getMaskEdit().setPlaceholderCharacter(' ');
        try {
            this.getMaskEdit().setMask(mask);
            this._maskFormat = mask;
        }
        catch (ParseException e) {
            log.error((Object)e.toString());
        }
    }

    public MciFoneField(MaskFormatter m) {
        super(m);
    }

    public Object getFieldValue() {
        String text = null;
        String textSemMascara = null;
        String fone = null;
        textSemMascara = this.getTextSemMascara();
        text = this.getText();
        if (textSemMascara != null && !textSemMascara.equals("")) {
            return text;
        }
        fone = new String();
        return fone;
    }

    @Override
    public Object getValue() {
        Object value = null;
        if (this.getText() != null) {
            String text = this.getText();
            String textSemMascara = this.getTextSemMascara();
            if (!text.equals("") && !text.equals(this._maskFormat)) {
                value = textSemMascara.equals("") ? "" : super.getValue();
            }
        }
        return value;
    }

    public void setPlaceholderCharacter(char chr) {
        this.getMaskEdit().setPlaceholderCharacter(chr);
    }

    public MaskFormatter getFoneFormat() {
        return this._foneFormat;
    }

    public void setFoneFormat(MaskFormatter foneFormat) {
        this._foneFormat = foneFormat;
    }

    private void mostraAviso() {
        int option = 1;
        Object[] options = new Object[]{"    Ok    "};
        option = JOptionPane.showOptionDialog(MciWizardHelper.getInstance().getForm(), this._errorMessage, "Aviso de Verifica\u00e7\u00e3o", 0, 2, null, options, options[0]);
    }

    @Override
    public void setText(String t) {
        if (t != null && !t.equals("")) {
            this.getMaskEdit().setAllowsInvalid(true);
            super.setText(t);
            this.setCaretPosition(0);
            this.getMaskEdit().setAllowsInvalid(false);
        } else {
            super.setText(t);
        }
    }

    @Override
    public void setEditable(boolean enabled) {
        if (!enabled) {
            this.setText("");
            try {
                ((MaskFormatter)this.getFormatter()).setMask("");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (this.getMaskEdit() != null && (this.getMaskEdit().getMask() == null || this.getMaskEdit().getMask().equals(""))) {
            try {
                ((MaskFormatter)this.getFormatter()).setMask(this._maskFormat);
                ((MaskFormatter)this.getFormatter()).install(this);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        super.setEditable(enabled);
    }

    @Override
    public String getTextSemMascara() {
        String text = this.getText();
        if (text.trim().equals("") || text.equals("(  )        ")) {
            return "";
        }
        String fone = text.replace('(', ' ').replace(')', ' ').replaceAll(" ", "").trim();
        try {
            Long.parseLong(fone);
        }
        catch (NumberFormatException e) {
            this._errorMessage = new String("Campo telefone deve ser preenchido somente com valores num\u00e9ricos.");
        }
        for (int i = 4; i < text.length() - 1; ++i) {
            if (text.charAt(i) != ' ') continue;
            this._errorMessage = new String("Campo Fone deve estar preenchido adequadamente.");
        }
        return fone;
    }

    public String getTextSemMascaraSemDDD() {
        String text = this.getText().replaceAll(" ", "").trim();
        return text.substring(text.indexOf(41) + 1);
    }

    public boolean verify(JComponent input) {
        long fone = 0L;
        boolean ok = true;
        MciFoneField field = (MciFoneField)input;
        MaskFormatter formatter = field.getMaskEdit();
        String text = field.getText();
        String textSemMascara = field.getTextSemMascara();
        if (textSemMascara != null) {
            if (!textSemMascara.equals("")) {
                if (formatter != null) {
                    try {
                        fone = Long.valueOf(textSemMascara);
                        ok = true;
                    }
                    catch (Exception e) {
                        ok = false;
                    }
                    if (field.getTextSemMascaraSemDDD().length() < 7) {
                        ok = false;
                    }
                }
            } else {
                ok = true;
            }
        }
        return ok;
    }

    class FoneFocusListener
    implements FocusListener {
        FoneFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object obj = e.getSource();
            String textoSemMascara = MciFoneField.this.getTextSemMascara();
            if (textoSemMascara == null || textoSemMascara.equals("")) {
                if (obj instanceof MciFoneField) {
                    ((MaskFormatter)((MciFoneField)obj).getFormatter()).install((MciFoneField)obj);
                }
            } else {
                MciFoneField text = (MciFoneField)obj;
                text.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            MciFoneField text = (MciFoneField)e.getSource();
            boolean teste = MciFoneField.this.verify(text);
            if (!teste) {
                MciFoneField.this.mostraAviso();
                text.requestFocusInWindow();
                text.setText("");
            }
        }
    }
}

