/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel.action;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.excecao.TransferenciaException;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.EnviaArquivosHttp;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.action.MciAbstractAction;
import br.gov.rs.tce.mci.visao.panel.TelaUC029_04;
import br.gov.rs.tce.pcdi.ws.soap.webservice.Response;
import br.gov.rs.tce.ws.recepcao.client.RecepcaoWSClient;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC029_04
extends MciAbstractAction {
    private static final String ESCOLHIDO_PRE = "EscolhidoPre";

    public ActionAvancarUC029_04() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(MciModelo tela, BindingContext binding) throws MCIActionException {
        TelaUC029_04 t29 = (TelaUC029_04)tela;
        if (t29.userServicoPcdi2()) {
            return this.enviarPCDI2(tela, binding);
        }
        return this.enviarHTTP(tela, binding);
    }

    private Row getRemessasRow(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        ViewObject voRemCam = ser.findViewObject("RemessasMCIView");
        return voRemCam.getCurrentRow();
    }

    private boolean enviarHTTP(MciModelo tela, BindingContext binding) {
        EnviaArquivosHttp enviaHttp = null;
        boolean ok = false;
        try {
            String URL_PCDI = TelaUC029_04.carregaConfigUrl();
            Remessa remessa = ActionAvancarUC029_04.getRemessaDataControl(binding);
            enviaHttp = new EnviaArquivosHttp(new URL(URL_PCDI));
            BarraProgressoModel modelProgresso = new BarraProgressoModel();
            enviaHttp.addChangeListener(modelProgresso);
            enviaHttp.addChangeListener(((TelaUC029_04)tela).getListenerInfoExtentidas());
            enviaHttp.adicionaCampoComValor("cdAplicacao", "mciw" + remessa.getCdEntidade() + "I");
            enviaHttp.adicionaCampoComValor("acao", "TESTE");
            if (enviaHttp.testaEnvioHttp()) {
                enviaHttp = new EnviaArquivosHttp(new URL(URL_PCDI));
                enviaHttp.addChangeListener(modelProgresso);
                enviaHttp.addChangeListener(((TelaUC029_04)tela).getListenerInfoExtentidas());
                enviaHttp.adicionaCampoComValor("cdAplicacao", "mciw" + remessa.getCdEntidade() + "I");
                enviaHttp.adicionaCampoComValor("acao", "ENVIO");
                enviaHttp.adicionaArquivo(EnviaArquivosHttp.criaIdentificadorArquivo("arquivo", new File("remessa/remessa.dat")));
                ((TelaUC029_04)tela).defineModeloProgresso(modelProgresso);
                enviaHttp.iniciaEnvioHttp();
                ok = true;
                if (((String)this.getRemessasRow(binding).getAttribute(ESCOLHIDO_PRE)).equalsIgnoreCase("S")) {
                    ActionAvancarUC029_04.exibeMensagemAviso("Dados enviados com sucesso. Verifique o recibo da remessa no site do TCE-RS:\n\nPortal TCE > Jurisdicionados > Sistemas de Controle Externo > SIAPC > Relat\u00f3rios e Recibos de Envio", (Component)((Object)tela));
                } else {
                    ActionAvancarUC029_04.exibeMensagemAviso("Dados enviados com sucesso.", (Component)((Object)tela));
                }
            }
        }
        catch (ConnectException ce) {
            enviaHttp.setSituacao("Informa\u00e7\u00f5es estendidas");
            ActionAvancarUC029_04.exibeMensagemErro("<html>N\u00e3o foi poss\u00edvel estabelecer uma conex\u00e3o com o servidor do TCE.<BR>Verifique sua conex\u00e3o com a Internet ou suas configura\u00e7\u00f5es de servidor Proxy<br> caso utilize um para se conectar \u00e0 Internet. <BR>Erro: " + ce.getMessage() + "</html>", (Component)((Object)tela));
            this.log.error((Object)ce);
            ce.printStackTrace();
        }
        catch (IOException e) {
            enviaHttp.setSituacao("Informa\u00e7\u00f5es estendidas");
            ActionAvancarUC029_04.exibeMensagemErro("<html>N\u00e3o foi poss\u00edvel estabelecer uma conex\u00e3o com o servidor do TCE.<BR>Dados adicionais do erro: " + e.getMessage() + ".</html>", (Component)((Object)tela));
            this.log.error((Object)e);
            e.printStackTrace();
        }
        catch (TransferenciaException e) {
            enviaHttp.setSituacao(e.getMessage());
            ActionAvancarUC029_04.exibeMensagemErro(e.getMessage(), (Component)((Object)tela));
        }
        return ok;
    }

    private boolean enviarPCDI2(MciModelo tela, BindingContext binding) {
        boolean ok = false;
        try {
            BarraProgressoModel modelProgresso = new BarraProgressoModel();
            ((TelaUC029_04)tela).defineModeloProgresso(modelProgresso);
            ((TelaUC029_04)tela).isProgressoIndeterminado(true);
            ResponsaveisWSClient.initalize();
            RecepcaoWSClient.initalize();
            String absolutePath = new File("").getAbsolutePath();
            File fileRemessa = new File(absolutePath + "/remessa/remessa.dat");
            FileDataSource fileDataSource = new FileDataSource(fileRemessa);
            byte[] encoded = Files.readAllBytes(Paths.get(absolutePath + "/remessa/remessa_info.xml", new String[0]));
            Response reponseCode = RecepcaoWSClient.receberNormal(new DataHandler((DataSource)fileDataSource), new String(encoded, Charset.defaultCharset()), fileRemessa.length());
            EnviaArquivosHttp.analisaResponse(reponseCode);
            ((TelaUC029_04)tela).setLabel("Arquivo enviado com sucesso");
            ((TelaUC029_04)tela).isProgressoIndeterminado(false);
            modelProgresso.setValue(modelProgresso.getMaximum());
            if (((String)this.getRemessasRow(binding).getAttribute(ESCOLHIDO_PRE)).equalsIgnoreCase("S")) {
                ActionAvancarUC029_04.exibeMensagemAviso("Dados enviados com sucesso. Verifique o recibo da remessa no site do TCE-RS:\n\nPortal TCE > Jurisdicionados > Sistemas de Controle Externo > SIAPC > Relat\u00f3rios e Recibos de Envio", (Component)((Object)tela));
            } else {
                ActionAvancarUC029_04.exibeMensagemAviso("Dados enviados com sucesso.", (Component)((Object)tela));
            }
            ok = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ((TelaUC029_04)tela).isProgressoIndeterminado(false);
            ActionAvancarUC029_04.exibeMensagemErro(e.getMessage(), (Component)((Object)tela));
        }
        return ok;
    }

    private class BarraProgressoModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        public BarraProgressoModel() {
            this.setMinimum(0);
            this.setMaximum(100);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            EnviaArquivosHttp envio = (EnviaArquivosHttp)event.getSource();
            this.setValue(envio.getProgresso());
        }
    }
}

