/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel.action;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.modelo.ConstantesArquivos;
import br.gov.rs.tce.mci.util.CompactacaoHelper;
import br.gov.rs.tce.mci.util.CopiaArquivoEvent;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.action.MciAbstractAction;
import br.gov.rs.tce.mci.visao.panel.TelaUC029_03;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC029_03
extends MciAbstractAction {
    private BindingContext _binding;
    private TelaUC029_03 _tela;

    @Override
    public boolean executaAction(MciModelo tela, BindingContext binding) throws MCIActionException {
        TelaUC029_03 t = (TelaUC029_03)tela;
        this._tela = (TelaUC029_03)tela;
        boolean retorno = false;
        this._binding = binding;
        MciWizardForm form = MciWizardHelper.getInstance().getForm();
        Remessa rem = ActionAvancarUC029_03.getRemessaDataControl(binding);
        if (t.getPath() == null || "".equals(t.getPath())) {
            ActionAvancarUC029_03.exibeMensagemAviso("Local de destino da remessa deve ser informado", form);
            return false;
        }
        File fDestino = new File(t.getPath());
        if (!fDestino.exists()) {
            ActionAvancarUC029_03.exibeMensagemAviso("Local de destino da remessa n\u00e3o \u00e9 valido", form);
            return false;
        }
        File fRemessa = new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP + "remessa.dat");
        File ftest = new File(t.getPath() + File.separator + "remessa.dat");
        try {
            if (fRemessa.getCanonicalFile().equals(ftest.getCanonicalFile())) {
                ActionAvancarUC029_03.exibeMensagemAviso("Local de destino da remessa n\u00e3o pode ser a pasta \"remessa\"", form);
                return false;
            }
        }
        catch (IOException e1) {
            throw new MCIActionException("UC029", ActionAvancarUC029_03.class.toString(), e1);
        }
        if (ftest.exists() && !ActionAvancarUC029_03.exibeMensagemSimNao("Existe uma remessa no local informado. Deseja sobrescrever?", form)) {
            return false;
        }
        try {
            t.acaoBanner(true);
            ProgressBarBoundedRangeModel copia = new ProgressBarBoundedRangeModel();
            t.setProgressoArquivoModel(copia);
            t.setMaxValueProgressBar(100);
            CompactacaoHelper comp = new CompactacaoHelper();
            retorno = comp.copiaArquivoRemessa(fRemessa, fDestino, copia);
            if (this._tela.ehAcaoBackup()) {
                ActionAvancarUC029_03.exibeMensagemAviso("<html>A grava\u00e7\u00e3o dos arquivos de backup foi finalizada com sucesso.</html>", form);
            } else {
                ActionAvancarUC029_03.exibeMensagemAviso("<html>A grava\u00e7\u00e3o dos arquivos de informa\u00e7\u00f5es foi finalizada com sucesso.</html>", form);
            }
            retorno = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MCIActionException("UC029_03", "br.gov.rs.tce.mci.visao.panel.action.ActionAvancarUC029_03.class", e);
        }
        retorno = true;
        t.acaoBanner(false);
        return retorno;
    }

    class ProgressBarBoundedRangeModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        private CopiaArquivoEvent copia;

        ProgressBarBoundedRangeModel() {
            this.setMaximum(100);
            this.setValue(0);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CopiaArquivoEvent copia = (CopiaArquivoEvent)event;
            CompactacaoHelper comp = (CompactacaoHelper)event.getSource();
            switch (copia.getSituacao()) {
                case -4: {
                    this.copia = copia;
                    break;
                }
                default: {
                    this.setValue(copia.getSituacao());
                }
            }
        }
    }
}

