/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel.action;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.excecao.SenhaInvalidaException;
import br.gov.rs.tce.mci.modelo.ConstantesArquivos;
import br.gov.rs.tce.mci.modelo.RemessaControle;
import br.gov.rs.tce.mci.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.action.MciAbstractAction;
import br.gov.rs.tce.mci.visao.panel.TelaUC027;
import java.awt.Component;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC027
extends MciAbstractAction {
    private TelaUC027 _tela027;
    private static int flagGeracao = 1;

    public ActionAvancarUC027() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(MciModelo tela, BindingContext binding) throws MCIActionException {
        File arquivoPFX = null;
        char[] senha = null;
        this._tela027 = (TelaUC027)tela;
        boolean retorno = false;
        this._tela027.setStatus("");
        Remessa remessa = ActionAvancarUC027.getRemessaDataControl(binding);
        if (flagGeracao == 1) {
            if (this._tela027.isCertificadoProprio()) {
                remessa.setTipoCertificado("P");
                senha = this._tela027.getSenhaAcessoCertificado();
                arquivoPFX = this._tela027.getPFXPath();
                if (arquivoPFX == null || !arquivoPFX.exists()) {
                    ActionAvancarUC027.exibeMensagemAviso("O caminho para o arquivo de certificado \u00e9 inv\u00e1lido.", (Component)((Object)tela));
                    return false;
                }
                if (senha == null) {
                    ActionAvancarUC027.exibeMensagemAviso("A senha informada \u00e9 inv\u00e1lida.", (Component)((Object)tela));
                    return false;
                }
            } else {
                remessa.setTipoCertificado("D");
            }
            Remessa remPrincipal = this.getRemessaPrincipal(binding);
            remPrincipal.setTipoCertificado(remessa.getTipoCertificado());
            try {
                ActionAvancarUC027.getServicoMCIAppModule(binding).atualizaCampoRemessa("VersaoMci", "3.0.1.9");
                ActionAvancarUC027.getServicoMCIAppModule(binding).atualizaDataGravacao("DtGravacao", "");
                ActionAvancarUC027.getServicoMCIAppModule(binding).getTransaction().commit();
            }
            catch (Exception e) {
                this.log.error((Object)"Erro ao setar vers\u00e3o do mci na tabela", (Throwable)e);
            }
            this.log.info((Object)("user.dir = " + System.getProperty("user.dir")));
            this.salvaDadosRemessa(binding);
            NotificaEventos notifica = new NotificaEventos();
            RelatorioControle relatorios = new RelatorioControle(notifica);
            this.log.debug((Object)"vai gerar relatorios");
            relatorios.geraRelatorios(remPrincipal, DatacontrolHelper.getServicoMCIAppModule(binding), null, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), true, false);
            this.log.debug((Object)"gerou relatorios");
            try {
                this.log.debug((Object)"vai gerar remessa");
                RemessaControle ctrl = new RemessaControle(remPrincipal, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), notifica);
                ctrl.geraRemessa(ActionAvancarUC027.getServicoMCIAppModule(binding), senha, arquivoPFX);
                this.log.debug((Object)"gerou remessa");
                retorno = true;
                this.log.debug((Object)"vai gerar relatorios em pdf");
                relatorios.geraRelatorios(remPrincipal, DatacontrolHelper.getServicoMCIAppModule(binding), null, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), false, true);
                this.log.debug((Object)"gerou relatorios pdf");
                ctrl.compactaArquivosXml();
                ctrl.geraArquivoCrpPDFs();
                ctrl.geraZipAssinado(new File(ctrl.getPath() + "remessa.dat"));
                this.log.debug((Object)"removendo arquivos");
                ctrl.removeArquivosRemessa();
            }
            catch (SenhaInvalidaException e) {
                MciWizardForm form = MciWizardHelper.getInstance().getForm();
                ActionAvancarUC027.exibeMensagemAviso(e.getMessage(), form);
                return false;
            }
            catch (ConfiguracaoException e) {
                MciWizardForm form = MciWizardHelper.getInstance().getForm();
                ActionAvancarUC027.exibeMensagemAviso(e.getMessage(), form);
                return false;
            }
            if (retorno) {
                flagGeracao = 0;
                this._tela027.setBotao("Avan\u00e7ar >");
                MciWizardForm form = MciWizardHelper.getInstance().getForm();
                ActionAvancarUC027.exibeMensagemAviso("Arquivo de Remessa Gerado com Sucesso", form);
                this._tela027.setMensagem("Clique em \"Avan\u00e7ar\" para continuar, ou \"Fechar\" para sair do MCI");
            }
            retorno = false;
        } else {
            retorno = true;
        }
        return retorno;
    }

    public void setFlagAssinatura(int flag) {
        flagGeracao = flag;
    }

    class NotificaEventos
    implements ChangeListener {
        NotificaEventos() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            try {
                RemessaControle copia;
                if (event.getSource() instanceof RelatorioControle) {
                    RelatorioControle copia2 = (RelatorioControle)event.getSource();
                    if (copia2.getSituacao() != null) {
                        ActionAvancarUC027.this._tela027.addStatus(copia2.getSituacao());
                    }
                } else if (event.getSource() instanceof RemessaControle && (copia = (RemessaControle)event.getSource()).getSituacao() != null) {
                    ActionAvancarUC027.this._tela027.addStatus(copia.getSituacao());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

