/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel.action;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.excecao.PersistenciaException;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.action.MciAbstractAction;
import br.gov.rs.tce.mci.visao.panel.TelaUC002_02;
import br.gov.rs.tce.mci.visao.util.Observacoes;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;

public class ActionAvancarUC002_02
extends MciAbstractAction {
    private static final String UC002_15 = "\u00c9 preciso haver ao menos um respons\u00e1vel cadastrado";
    private static final String UC002_16 = "N\u00e3o \u00e9 poss\u00edvel haver mais de um respons\u00e1vel cadastrado";
    private static final String UC002_17 = "O cadastro desse registro precisa ser alterado para prosseguir";
    private static final String UC002_19 = "Esse CPF j\u00e1 est\u00e1 cadastrado!";

    @Override
    public boolean executaAction(MciModelo tela, BindingContext binding) throws MCIActionException {
        TelaUC002_02 t = (TelaUC002_02)tela;
        boolean validaDados = false;
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        Remessa remessa = ActionAvancarUC002_02.getRemessaDataControl(binding);
        Observacoes obs = new Observacoes();
        obs.insereObservacoes(ser, remessa, "UC002_02");
        if (t.validaTela()) {
            this.salvaDadosRemessa(binding);
            if (ser.getNroResponsaveis() > 1) {
                t.exibeWarning(UC002_16);
                t.exibeWarning(UC002_17);
                validaDados = false;
            } else if (ser.getNroResponsaveis() < 1) {
                t.exibeWarning(UC002_15);
                validaDados = false;
            } else {
                if (ser.getCPFCadastrado(t.getCpfParam()) > 1) {
                    t.exibeWarning(UC002_19);
                    return false;
                }
                System.out.println(">> comitando...");
                this.salvaDadosRemessa(binding);
                validaDados = true;
            }
        } else {
            validaDados = false;
        }
        return validaDados;
    }

    public int getNroIntegrantesSemFormacaoInformada(BindingContext binding) {
        int retorno;
        try {
            DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
            ApplicationModule am = dc.getApplicationModule();
            ViewObject vo = am.findViewObject("CadcontinternoView");
            vo.setWhereClause("formacao = 0");
            vo.executeQuery();
            retorno = vo.getRowCount();
            vo.setWhereClause(null);
            vo.setWhereClauseParams(null);
            vo.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir o CodEntidade no CadConsInterno"}, e);
        }
        return retorno;
    }
}

