/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC034
extends JPanel
implements JUPanel,
MciModelo {
    public static final String CD = "CD";
    public static final String DISQUETE = "DISQUETE";
    public static final String ORIGINAL = "ORIGINAL";
    public static final String BACKUP = "BACKUP";
    private String _qualMidia;
    private String _discoAtual;
    private String _totalDiscos;
    private String _tipoImpressao;
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC034UIModel");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel PnlNort = new JPanel();
    private JPanel PnlCenter = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private XYLayout xYLayout2 = new XYLayout();
    private JTextArea textEtiqueta = new JTextArea();
    private ScrollPane scrollPaneEtiqueta = new ScrollPane();
    private BindingContext _bindingContext;
    private String _nomeEntidade;
    private String _codBarrasMCI;
    private String _codBarrasOriginalPAD;

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(429, 286));
        this.add((Component)this.PnlCenter, "Center");
        this.scrollPaneEtiqueta.setEnabled(false);
        this.PnlNort.setSize(new Dimension(220, 150));
        this.PnlNort.setPreferredSize(new Dimension(375, 100));
        this.PnlNort.setMaximumSize(new Dimension(800, 600));
        this.PnlNort.setMinimumSize(new Dimension(275, 40));
        this.PnlNort.setLayout((LayoutManager)this.xYLayout2);
        this.PnlNort.setBorder(BorderFactory.createEtchedBorder(1));
        this.PnlCenter.setLayout((LayoutManager)this.xYLayout1);
        this.PnlCenter.setSize(new Dimension(425, 175));
        this.PnlCenter.setMaximumSize(new Dimension(800, 600));
        this.PnlCenter.setPreferredSize(new Dimension(400, 175));
        this.PnlCenter.setMinimumSize(new Dimension(100, 100));
        this.PnlCenter.setBorder(BorderFactory.createEtchedBorder(1));
        String[] aux = this.criaEtiqueta(this.getMidia(), false);
        this.textEtiqueta.setText(aux[0]);
        this.scrollPaneEtiqueta.add((Component)this.textEtiqueta, null);
        this.PnlNort.add((Component)this.scrollPaneEtiqueta, new XYConstraints(5, 5, 390, 250));
        this.PnlCenter.add((Component)this.PnlNort, new XYConstraints(5, 5, 405, 265));
    }

    private String[] criaEtiqueta(String midia, boolean isPrint) {
        String perAte;
        ServicoMCI ser = DatacontrolHelper.getServicoMCIAppModule(this._bindingContext);
        Remessa _remessa = this.getRemessaPrincipal(ser);
        String nomeEntidade = ser.getNomeEntidade(_remessa);
        System.out.println(_remessa.getCodBarrasMCI());
        this.setCodBarrasMCI(_remessa.getCodBarrasMCI());
        this.setCodBarrasOriginalPAD(_remessa.getCodBarrasOriginalPAD());
        this.setNomeDaEntidade(nomeEntidade);
        StringBuffer etiqueta = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        int mesPeriodo = _remessa.getMesFinalInformacoes();
        int anoRef = _remessa.getAnoExercicio();
        String disOri = "1";
        String perDe = "01/01/" + anoRef;
        String[] retorno = isPrint ? new String[13] : new String[1];
        if (mesPeriodo == 1 || mesPeriodo == 3 || mesPeriodo == 5 || mesPeriodo == 7 || mesPeriodo == 8 || mesPeriodo == 10 || mesPeriodo == 12) {
            perAte = "31/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else if (mesPeriodo == 4 || mesPeriodo == 6 || mesPeriodo == 9 || mesPeriodo == 11) {
            perAte = "30/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else {
            perAte = anoRef % 4 == 0 && anoRef % 100 != 0 || anoRef % 400 == 0 ? "29/0" + mesPeriodo + "/" + anoRef : "28/0" + mesPeriodo + "/" + anoRef;
        }
        if (isPrint) {
            retorno[0] = new String("===================================");
        } else {
            etiqueta.append("=============================================\n");
        }
        if (isPrint) {
            retorno[1] = new String("  Tribunal de Contas do Estado do R.S.\n");
        } else {
            etiqueta.append("  Tribunal de Contas do Estado do R.S.\n");
        }
        if (isPrint) {
            retorno[2] = new String("  SIAPC - Vers\u00e3o 3.0.1.9\n");
        } else {
            etiqueta.append("  SIAPC - Vers\u00e3o 3.0.1.9\n");
        }
        if (isPrint) {
            retorno[3] = new String("  MCI - Manifesta\u00e7\u00e3o do Controle Interno\n");
        } else {
            etiqueta.append("  MCI - Manifesta\u00e7\u00e3o do Controle Interno\n");
        }
        if (isPrint) {
            retorno[4] = new String("  " + nomeEntidade + "\n");
        } else {
            etiqueta.append("  " + nomeEntidade + "\n");
        }
        if (isPrint) {
            retorno[5] = new String("  CNPJ: " + _remessa.getCnpjEntidade() + "\n");
        } else {
            etiqueta.append("  CNPJ: " + _remessa.getCnpjEntidade() + "\n");
        }
        if (isPrint) {
            retorno[6] = new String("  Ano de Refer\u00eancia: " + anoRef + "\n");
        } else {
            etiqueta.append("  Ano de Refer\u00eancia: " + anoRef + "\n");
        }
        if (isPrint) {
            retorno[7] = new String("  Per\u00edodo: " + perDe + " at\u00e9 " + perAte + "\n");
        } else {
            etiqueta.append("  Per\u00edodo: " + perDe + " at\u00e9 " + perAte + "\n");
        }
        if (midia.equalsIgnoreCase(DISQUETE)) {
            if (isPrint) {
                retorno[8] = new String("  C\u00f3d. Barras MCI: " + this.getCodBarrasMCI() + "\n");
            } else {
                etiqueta.append("  C\u00f3d. Barras MCI: " + this.getCodBarrasMCI() + "\n");
            }
            if (isPrint) {
                retorno[9] = new String("  C\u00f3d. Barras PAD: " + this.getCodBarrasOriginalPAD() + "\n");
            } else {
                etiqueta.append("  C\u00f3d. Barras PAD: " + this.getCodBarrasOriginalPAD() + "\n");
            }
            if (isPrint) {
                retorno[10] = new String("  Data de Gera\u00e7\u00e3o do " + midia + ": " + formatter.format(new Date()) + "\n");
            } else {
                etiqueta.append("  Data de Gera\u00e7\u00e3o do " + midia + ": " + formatter.format(new Date()) + "\n");
            }
            if (isPrint) {
                retorno[11] = new String("  Disquete " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            } else {
                etiqueta.append("  Disquete " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            }
        } else {
            if (isPrint) {
                retorno[8] = new String("  C\u00f3d. Barras MCI: " + this.getCodBarrasMCI() + "\n");
            } else {
                etiqueta.append("  C\u00f3d. Barras MCI: " + this.getCodBarrasMCI() + "\n");
            }
            if (isPrint) {
                retorno[9] = new String("  C\u00f3d. Barras PAD: " + this.getCodBarrasOriginalPAD() + "\n");
            } else {
                etiqueta.append("  C\u00f3d. Barras PAD: " + this.getCodBarrasOriginalPAD() + "\n");
            }
            if (isPrint) {
                retorno[10] = new String("  Data de Gera\u00e7\u00e3o do " + midia + ": " + formatter.format(new Date()) + "\n");
            } else {
                etiqueta.append("  Data de Gera\u00e7\u00e3o do " + midia + ": " + formatter.format(new Date()) + "\n");
            }
            if (isPrint) {
                retorno[11] = new String("  CD " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            } else {
                etiqueta.append("  CD " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            }
        }
        if (isPrint) {
            retorno[12] = new String("===================================");
        } else {
            etiqueta.append("=============================================\n");
        }
        if (!isPrint) {
            retorno[0] = etiqueta.toString();
        }
        return retorno;
    }

    private void setNomeDaEntidade(String nomeEntidade) {
        this._nomeEntidade = nomeEntidade;
    }

    public String getNomeDaEntidade() {
        return this._nomeEntidade;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void preparaTela() {
        System.out.println("preparaTela");
    }

    @Override
    public void finalizaTela() {
        System.out.println("finalizaTela");
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    private void btnCancelar_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void buttonOk_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat documentPageFormat = new PageFormat();
        documentPageFormat.setOrientation(1);
        book.append(new Document(), documentPageFormat);
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public void setMidia(String pMidia) {
        this._qualMidia = pMidia;
    }

    public String getMidia() {
        return this._qualMidia;
    }

    public void setTipoImpressao(String pTipoImpressao) {
        this._tipoImpressao = pTipoImpressao;
    }

    public String getTipoImpressao() {
        return this._tipoImpressao;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC034 panel = new TelaUC034();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(500, 400)));
        panel.revalidate();
    }

    public void setDiscoAtual(String disco) {
        this._discoAtual = disco;
    }

    public void setTotalDiscos(String total) {
        this._totalDiscos = total;
    }

    public String getCodBarrasMCI() {
        return this._codBarrasMCI;
    }

    public void setCodBarrasMCI(String _codBarrasMCI) {
        this._codBarrasMCI = _codBarrasMCI;
    }

    public String getCodBarrasOriginalPAD() {
        return this._codBarrasOriginalPAD;
    }

    public void setCodBarrasOriginalPAD(String _codBarrasOriginalPAD) {
        this._codBarrasOriginalPAD = _codBarrasOriginalPAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Remessa getRemessaPrincipal(ServicoMCI mciModule) {
        ViewObject remessasView = null;
        ViewObject entidadesView = null;
        Remessa remessa = null;
        try {
            remessasView = mciModule.createViewObjectFromQueryStmt("RemessaPrincipal", "SELECT * FROM MCI.MCI_REMESSASMCI");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            entidadesView = mciModule.createViewObjectFromQueryStmt("Entidades", "SELECT * FROM MCI.MCI_ENTIDADES");
            entidadesView.setWhereClause("CD_ENTIDADE = " + remessaRow.getAttribute("CD_ENTIDADE"));
            entidadesView.executeQuery();
            Row entidadeRow = entidadesView.first();
            remessa = new Remessa();
            Integer anoExercicio = new Integer(((BigDecimal)remessaRow.getAttribute("ANO_EXERCICIO")).intValue());
            if (anoExercicio != null) {
                remessa.setAnoExercicio(anoExercicio);
            }
            String tpEntrega = (String)remessaRow.getAttribute("TPENTREGA");
            remessa.setTipoEntrega(tpEntrega);
            Integer peridodo = new Integer(((BigDecimal)remessaRow.getAttribute("CD_PERIODO")).intValue());
            remessa.setPeriodoInformacoes(peridodo);
            remessa.setCdEntidade(new Integer(((BigDecimal)remessaRow.getAttribute("CD_ENTIDADE")).intValue()));
            String tpSetor = (String)remessaRow.getAttribute("PODER");
            remessa.setTipoSetor(tpSetor);
            String cnpj = (String)entidadeRow.getAttribute("CNPJ");
            remessa.setCnpjEntidade(cnpj);
            String codBarrasMCI = (String)remessaRow.getAttribute("COD_BARRAS");
            remessa.setCodBarrasMCI(codBarrasMCI);
            String codBarrasMod9 = (String)remessaRow.getAttribute("COD_BARRASMOD9");
            String codBarrasMod14 = (String)remessaRow.getAttribute("COD_BARRASMOD14");
            if (tpSetor.equalsIgnoreCase("P")) {
                remessa.setCodBarrasOriginalPAD(codBarrasMod9);
            } else {
                remessa.setCodBarrasOriginalPAD(codBarrasMod14);
            }
        }
        finally {
            if (remessasView != null) {
                remessasView.remove();
            }
            if (entidadesView != null) {
                entidadesView.remove();
            }
        }
        return remessa;
    }

    private class Document
    implements Printable {
        private Document() {
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int page) {
            String nomeEntidade = TelaUC034.this.getNomeDaEntidade();
            double widthEntity = 0.5;
            double linha4 = 1.1;
            if (nomeEntidade != null) {
                if (nomeEntidade.length() <= 12) {
                    widthEntity = 0.6;
                } else if (nomeEntidade.length() > 12 && nomeEntidade.length() <= 22) {
                    widthEntity = 0.9;
                } else if (nomeEntidade.length() > 22) {
                    widthEntity = 1.2;
                }
            }
            int POINTS_PER_INCH = 140;
            int SIZE_FONT = 9;
            int LARGURA_ETIQUETA = 205;
            int COMPRIMENTO_ETIQUETA = 150;
            double POSICAO_LATERAL = 0.1;
            double POSICAO_SUPERIOR = 0.01;
            if (TelaUC034.this.getMidia().equalsIgnoreCase(TelaUC034.CD)) {
                POINTS_PER_INCH = 215;
                SIZE_FONT = 15;
                LARGURA_ETIQUETA = 350;
                COMPRIMENTO_ETIQUETA = 335;
                POSICAO_LATERAL = 0.15;
                POSICAO_SUPERIOR = 0.2;
                linha4 = 1.2;
                if (nomeEntidade != null) {
                    if (nomeEntidade.length() <= 12) {
                        widthEntity = 0.7;
                    } else if (nomeEntidade.length() > 12 && nomeEntidade.length() <= 22) {
                        widthEntity = 1.1;
                    } else if (nomeEntidade.length() > 23) {
                        widthEntity = 1.3;
                    }
                }
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.setPaint(Color.black);
            g2d.setStroke(new BasicStroke(1.0f));
            Rectangle2D.Double border = new Rectangle2D.Double(0.0, 0.0, LARGURA_ETIQUETA, COMPRIMENTO_ETIQUETA);
            g2d.draw(border);
            String[] aaa = TelaUC034.this.criaEtiqueta(TelaUC034.this.getMidia(), true);
            Point2D.Double pen = new Point2D.Double(POSICAO_LATERAL * (double)POINTS_PER_INCH, POSICAO_SUPERIOR * (double)POINTS_PER_INCH);
            double width = 1.3 * (double)POINTS_PER_INCH;
            if (TelaUC034.this.getMidia().equalsIgnoreCase(TelaUC034.CD)) {
                width = 1.45 * (double)POINTS_PER_INCH;
            }
            for (int a = 0; a < aaa.length; ++a) {
                TextLayout layout;
                AttributedString paragraphText = new AttributedString(aaa[a]);
                paragraphText.addAttribute(TextAttribute.FONT, new Font("serif", 0, SIZE_FONT));
                LineBreakMeasurer lineBreaker = new LineBreakMeasurer(paragraphText.getIterator(), new FontRenderContext(null, true, true));
                Vector<TextLayout> lines = new Vector<TextLayout>();
                while ((layout = lineBreaker.nextLayout((float)width)) != null) {
                    lines.add(layout);
                }
                for (int i = 0; i < lines.size(); ++i) {
                    layout = (TextLayout)lines.get(i);
                    TextLayout justifyLayout = i != lines.size() - 1 ? layout.getJustifiedLayout((float)width) : layout;
                    pen.y += (double)justifyLayout.getAscent();
                    justifyLayout.draw(g2d, (float)pen.x, (float)pen.y);
                    pen.y += (double)(justifyLayout.getDescent() + justifyLayout.getLeading());
                }
            }
            return 0;
        }
    }
}

