/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.action;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.action.MciAction;
import java.awt.Component;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MciAbstractAction
implements MciAction {
    public static final int TRANSACAO_LIMPA = 0;
    public static final int TRANSACAO_SUJA_CANCELADA = 1;
    public static final int TRANSACAO_SUJA_SALVA = 2;
    protected Log log = LogFactory.getLog(MciAbstractAction.class);
    private boolean _criaThreadTratamentoAcao;

    public void salvaDadosRemessa(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        dc.commitTransaction();
    }

    public void cancelaDadosRemessa(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        dc.rollbackTransaction();
    }

    public static Remessa getRemessaDataControl(BindingContext binding) {
        return DatacontrolHelper.getRemessaDataControl(binding);
    }

    public static ServicoMCI getServicoMCIAppModule(BindingContext binding) {
        return DatacontrolHelper.getServicoMCIAppModule(binding);
    }

    @Override
    public abstract boolean executaAction(MciModelo var1, BindingContext var2) throws MCIActionException;

    @Override
    public final boolean isCriaThreadTratamentoAcao() {
        return this._criaThreadTratamentoAcao;
    }

    public final void setCriaThreadTratamentoAcao(boolean valor) {
        this._criaThreadTratamentoAcao = valor;
    }

    public static final void exibeMensagemAviso(String mensagem, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, "Informa\u00e7\u00e3o", 1);
    }

    public static final void exibeMensagemErro(String mensagem, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, "Erro", 0);
    }

    public static final void exibeMensagemAviso(String mensagem, String titulo, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, titulo, 1);
    }

    public static final boolean exibeMensagemSimNao(String mensagem, Component parent) {
        return MciAbstractAction.exibeMensagemSimNao(mensagem, "Aten\u00e7\u00e3o", parent);
    }

    public static final boolean exibeMensagemSimNao(String mensagem, String titulo, Component parent) {
        int option = 1;
        Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
        option = JOptionPane.showOptionDialog(parent, mensagem, titulo, 0, 3, null, options, options[0]);
        return option == 0;
    }

    protected int popupTransactionDialog(BindingContext binding, Component parent, String msg) {
        int status = 0;
        if (msg == null) {
            msg = "Voc\u00ea est\u00e1 saindo desta tela mas cadastrou ou alterou dados \ne N\u00c3O salvou suas informa\u00e7\u00f5es. Deseja salvar os dados e continuar ?";
        }
        if (binding.findDataControl("ServicoMCIDataControl").isTransactionDirty()) {
            status = MciAbstractAction.exibeMensagemSimNao(msg, parent) ? 2 : 1;
        }
        return status;
    }

    protected int popupTransactionDialogFeminino(BindingContext binding, Component parent, String nome) {
        int status = 0;
        if (binding.findDataControl("ServicoMCIDataControl").isTransactionDirty()) {
            if (nome == null) {
                nome = "Integrante";
            }
            String msg = "Voc\u00ea est\u00e1 saindo desta tela mas cadastrou ou alterou uma {0} \ne N\u00c3O salvou suas informa\u00e7\u00f5es. Deseja salvar os dados?";
            status = MciAbstractAction.exibeMensagemSimNao(msg = MessageFormat.format(msg, nome), parent) ? 2 : 1;
        }
        return status;
    }

    protected java.sql.Date getDateFormat(String value) {
        java.sql.Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            date = new java.sql.Date(((Date)dateFormat.parseObject(value)).getTime());
        }
        catch (ParseException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return date;
    }

    public Remessa getRemessaPrincipal(BindingContext ctx) {
        ServicoMCI ser = MciAbstractAction.getServicoMCIAppModule(ctx);
        return ser.getRemessaPrincipal();
    }
}

