/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao;

import br.gov.rs.tce.mci.beans.Tela;
import br.gov.rs.tce.mci.excecao.DecisaoTelaException;
import br.gov.rs.tce.mci.modelo.ConstantesUtil;
import br.gov.rs.tce.mci.modelo.decisao.DecisaoNavegacaoTelas;
import br.gov.rs.tce.mci.visao.MciDesktop;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import oracle.adf.model.BindingContext;

public final class MciWizardHelper {
    private MciWizardForm _form;
    private static MciWizardHelper _helper;
    public String titleDebugInfo = null;

    private MciWizardHelper() {
    }

    public static MciWizardHelper getInstance() {
        if (_helper == null) {
            _helper = new MciWizardHelper();
        }
        return _helper;
    }

    public void setMciWizardForm(MciWizardForm form) {
        this._form = form;
    }

    public void inicializaPanels() {
        Tela telaini = DecisaoNavegacaoTelas.getInstancia().getTelaInicial();
        MciModelo panel = MciWizardHelper.criaNovaTela(telaini.getPanelClass(), this._form.getBindingContext());
        this._form.getPagina().getMciWizardModelo().adicionaTelaModelo(telaini, panel);
        this.exibeTela(telaini, panel);
    }

    public void exibeTela(Tela tela, MciModelo panel) {
        this._form.getPagina().getMciWizardModelo().exibeTela(tela, panel);
        if (ConstantesUtil.isDebugModeEnabled()) {
            this._form.setTitle("MCI " + MciDesktop.getVersaoTitulo() + " - " + tela.getCodigo() + (this.titleDebugInfo != null ? " - " + this.titleDebugInfo : ""));
            this.titleDebugInfo = null;
        }
    }

    public MciWizardForm getForm() {
        return this._form;
    }

    public static MciModelo criaNovaTela(String tela, BindingContext ctx) {
        MciModelo modelo = null;
        try {
            modelo = (MciModelo)Class.forName(tela).newInstance();
            modelo.setBindingContext(ctx);
        }
        catch (Exception e) {
            throw new DecisaoTelaException("Erro ao instanciar tela: " + tela, e);
        }
        return modelo;
    }
}

