/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao;

import br.gov.rs.tce.mci.visao.action.MciAjudaAction;
import br.gov.rs.tce.mci.visao.action.MciAvancarAction;
import br.gov.rs.tce.mci.visao.action.MciFecharAction;
import br.gov.rs.tce.mci.visao.action.MciObservacoesAction;
import br.gov.rs.tce.mci.visao.action.MciSobreAction;
import br.gov.rs.tce.mci.visao.action.MciVoltarAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class MciWizardControle
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String AVANCAR = "Avan\u00e7ar >";
    public static final String FECHAR = "Fechar";
    public static final String VOLTAR = "< Voltar";
    public static final String AJUDA = "Ajuda";
    public static final String SOBRE = "Sobre";
    public static final String ENVIAR = "Enviar";
    public static final String GRAVAR = "Gravar";
    public static final String ASSINAR_REMESSA = "Assinar";
    public static final String GERAR_REMESSA = "Gerar";
    public static final String OBSERVACOES = "Observa\u00e7\u00f5es";
    public static final String CARREGAR = "Carregar";
    public static final int LARGURA = 85;
    public static final int ALTURA = 23;
    private JButton btNext;
    private JButton btBack;
    private JButton btClose;
    private JButton btAbout;
    private JButton btHelp;
    private JButton btObservacoes;
    private MciAvancarAction avancarAction;
    private MciVoltarAction voltarAction;
    private MciFecharAction fecharAction;
    private MciAjudaAction ajudaAction;
    private MciSobreAction sobreAction;
    private MciObservacoesAction observacoesAction;

    public MciWizardControle() {
        super(new BorderLayout());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.inicializaActions();
            this.inicializaPanel();
            this.habilitaBotaoVoltar(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void inicializaActions() {
        this.avancarAction = new MciAvancarAction(AVANCAR, "Avan\u00e7a para a pr\u00f3xima tela", new Integer(65));
        this.voltarAction = new MciVoltarAction(VOLTAR, "Volta a tela anterior.", new Integer(86));
        this.fecharAction = new MciFecharAction(FECHAR, "Fecha o programa.", new Integer(70));
        this.ajudaAction = new MciAjudaAction(AJUDA, "Exibe ajuda da tela atual.", new Integer(74));
        this.sobreAction = new MciSobreAction(SOBRE, "Exibe informa\u00e7\u00f5es sobre o MCI.", new Integer(83));
        this.observacoesAction = new MciObservacoesAction(OBSERVACOES, "Insere informa\u00e7\u00f5es sobre o item atual", new Integer(79));
    }

    private void inicializaPanel() {
        this.createButtons();
        this.btObservacoes.setVisible(false);
        this.addButtons();
    }

    private void createButtons() {
        this.btNext = new JButton(this.avancarAction);
        this.btBack = new JButton(this.voltarAction);
        this.btClose = new JButton(this.fecharAction);
        this.btAbout = new JButton(this.sobreAction);
        this.btHelp = new JButton(this.ajudaAction);
        this.btObservacoes = new JButton(this.observacoesAction);
        this.btNext.setPreferredSize(new Dimension(85, 23));
        this.btBack.setPreferredSize(new Dimension(85, 23));
        this.btClose.setPreferredSize(new Dimension(85, 23));
        this.btAbout.setPreferredSize(new Dimension(85, 23));
        this.btHelp.setPreferredSize(new Dimension(85, 23));
        this.btObservacoes.setPreferredSize(new Dimension(100, 23));
    }

    private void addButtons() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createPanelAbout(), "West");
        mainPanel.add((Component)this.createPanelControl(), "Center");
        mainPanel.add((Component)this.createPanelEnd(), "East");
        this.add((Component)new JSeparator(), "North");
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createPanelAbout() {
        JPanel panelStart = new JPanel();
        panelStart.add(this.btAbout);
        panelStart.add(this.btHelp);
        panelStart.add(this.btObservacoes);
        return panelStart;
    }

    private JPanel createPanelControl() {
        JPanel panelCenter = new JPanel();
        panelCenter.add(this.btBack);
        panelCenter.add(this.btNext);
        return panelCenter;
    }

    private JPanel createPanelEnd() {
        JPanel panelEnd = new JPanel();
        panelEnd.add(this.btClose);
        return panelEnd;
    }

    public void habilitaBotaoAvancar(boolean value) {
        this.btNext.setEnabled(value);
        this.repaintAvancar();
    }

    public void setaNomeAvancar(String value) {
        this.btNext.setText(value);
    }

    public void setaLarguraAvancar(int largura) {
        this.btNext.setPreferredSize(new Dimension(largura, 23));
    }

    public void habilitaBotaoVoltar(boolean value) {
        this.btBack.setEnabled(value);
        this.repaintVoltar();
    }

    public void habilitaBotaoFechar(boolean value) {
        this.btClose.setEnabled(value);
    }

    public void repaintAvancar() {
        this.btNext.repaint();
    }

    public void repaintVoltar() {
        this.btBack.repaint();
    }

    public void repaintObservacoes() {
        this.btObservacoes.repaint();
    }

    public void exibeBotaoObservacoes(boolean value) {
        this.btObservacoes.setVisible(value);
        this.repaintObservacoes();
    }
}

