/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao;

import br.gov.rs.tce.mci.excecao.SenhaInvalidaException;
import br.gov.rs.tce.mci.visao.JUErrorDialog;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCErrorHandler;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrSetValException;
import oracle.jbo.AttrValException;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.StringManager;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.uicli.UIMessageBundle;
import oracle.jbo.uicli.binding.JUErrorHandler;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.jui.JUIUtil;

public class MciErrorDialog
implements JUErrorHandler,
DCErrorHandler {
    boolean inReportException = false;
    JFrame _frame;

    public MciErrorDialog(JFrame frame) {
        this._frame = frame;
    }

    public void reportException(JUFormBinding formBnd, Exception ex) {
        this.reportException((DCBindingContainer)formBnd, ex);
    }

    public void reportException(DCBindingContainer formBnd, Exception ex) {
        this.reportException(formBnd, ex, false);
    }

    public void reportException(JUFormBinding formBnd, Exception ex, boolean reportExceptionNow) {
        this.reportException((DCBindingContainer)formBnd, ex, reportExceptionNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportException(DCBindingContainer formBnd, Exception ex, boolean reportErrorNow) {
        if (this.inReportException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("Warning JUErrorHandlerDlg ignoring " + ex.getClass().getName() + " while in reportException"));
            }
            return;
        }
        try {
            this.inReportException = true;
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("JUErrorHandlerDlg.reportException(" + ex.getClass().getName() + ")"));
            }
            Object panel = formBnd != null ? formBnd.getViewComponent() : null;
            Frame frm = null;
            if (panel instanceof JPanel) {
                frm = JUIUtil.getParentFrame((Component)((JPanel)panel));
            }
            ApplicationModule am = null;
            if (ex instanceof JboException && formBnd != null) {
                try {
                    am = (ApplicationModule)formBnd.getDataControl().getDataProvider();
                }
                catch (Exception ioe) {
                    Diagnostic.println((String)("JUErrorHandlerDlg.reportException ignoring :" + ioe));
                }
            }
            if (am != null) {
                try {
                    ViewObject[] vos = ((JUFormBinding)formBnd).getOrderedVOUsageList();
                    ((JboException)((Object)ex)).doEntityToVOMapping(am, vos);
                }
                catch (JboException e) {
                    Diagnostic.print((String)"Warning! Ignoring exception in JUFormBinding.getOrderedVOUsageList");
                    Diagnostic.printStackTrace((Throwable)e);
                }
            }
            class MyRunnable
            implements Runnable {
                Frame mFrame;
                Exception mEx;

                MyRunnable() {
                }

                @Override
                public void run() {
                    if (this.mEx instanceof AttrSetValException || this.mEx instanceof AttrValException || this.mEx instanceof SenhaInvalidaException) {
                        if (!(this.mEx instanceof DataCreationException)) {
                            String message = this.mEx.getMessage();
                            int isJBO = message.indexOf("JBO");
                            int offset = 0;
                            if (isJBO >= 0) {
                                offset = message.indexOf(":");
                                message = message.substring(++offset);
                            }
                            JOptionPane.showMessageDialog(MciErrorDialog.this._frame, message, "Aten\u00e7\u00e3o", 1);
                        }
                    } else {
                        JUErrorDialog dlg = new JUErrorDialog((Frame)MciErrorDialog.this._frame, StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02614", null, null), true, this.mEx);
                        dlg.showError();
                    }
                }
            }
            MyRunnable runnable = new MyRunnable();
            runnable.mFrame = frm;
            runnable.mEx = ex;
            if (reportErrorNow) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InvocationTargetException ite) {
                    Diagnostic.println((String)("JUErrorHandlerDlg.reportException ignoring :" + ite.getMessage()));
                }
                catch (InterruptedException ie) {
                    Diagnostic.println((String)("JUErrorHandlerDlg.reportException ignoring :" + ie.getMessage()));
                }
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        finally {
            this.inReportException = false;
        }
    }
}

