/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ValidaCPF {
    private static final NumberFormat nfCPF = new DecimalFormat("00000000000");

    private ValidaCPF() {
    }

    public static boolean validaCPF(Number cpf) {
        if (cpf == null) {
            return false;
        }
        long valorCPF = cpf.longValue();
        if (valorCPF > 99999999999999L) {
            return false;
        }
        String cpfStr = nfCPF.format(valorCPF);
        return ValidaCPF.validaCPF(cpfStr);
    }

    public static boolean validaCPF(String cpf) {
        int soma = 0;
        if (cpf.length() > 8 && cpf.length() < 11) {
            while (cpf.length() < 11) {
                cpf = "0" + cpf;
            }
        }
        if (cpf.length() == 11) {
            int i;
            for (i = 0; i < 9; ++i) {
                soma += (10 - i) * (cpf.charAt(i) - 48);
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == cpf.charAt(9) - 48) {
                soma = 0;
                for (i = 0; i < 10; ++i) {
                    soma += (11 - i) * (cpf.charAt(i) - 48);
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == cpf.charAt(10) - 48) {
                    return true;
                }
            }
        }
        return false;
    }
}

