/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import br.gov.rs.tce.mci.excecao.FormatoInvalidoException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class ValidaCNPJ {
    private String message;
    private static final String formatoCNPJ = "###.###.###/####-##";
    private static final NumberFormat nfCPF = new DecimalFormat("00000000000000");
    private static ValidaCNPJ _instance;

    private ValidaCNPJ() {
    }

    public static boolean validaCnpj(Number cnpj) {
        if (cnpj == null) {
            return false;
        }
        long valorCPF = cnpj.longValue();
        if (valorCPF > 99999999999L) {
            return false;
        }
        String cpf = nfCPF.format(valorCPF);
        return ValidaCNPJ.validaCnpj(cnpj);
    }

    public static boolean validaCnpj(String cnpj) {
        int soma = 0;
        try {
            Long.parseLong(cnpj);
        }
        catch (Exception e) {
            throw new FormatoInvalidoException((Object)cnpj, new Object[]{cnpj});
        }
        if (cnpj.length() > 8 && cnpj.length() < 14) {
            while (cnpj.length() < 14) {
                cnpj = "0" + cnpj;
            }
        }
        if (cnpj.length() == 14) {
            int i;
            int j = 5;
            for (i = 0; i < 12; ++i) {
                soma += j-- * (cnpj.charAt(i) - 48);
                if (j >= 2) continue;
                j = 9;
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == cnpj.charAt(12) - 48) {
                soma = 0;
                j = 6;
                for (i = 0; i < 13; ++i) {
                    soma += j-- * (cnpj.charAt(i) - 48);
                    if (j >= 2) continue;
                    j = 9;
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == cnpj.charAt(13) - 48) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String formataCnpj(String cnpj) {
        char[] chrs = null;
        StringBuffer cnpjFormatado = null;
        int offSet = 0;
        cnpjFormatado = new StringBuffer();
        chrs = formatoCNPJ.toCharArray();
        for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] != '#') {
                cnpjFormatado.append(chrs[index]);
                continue;
            }
            cnpjFormatado.append(cnpj.substring(offSet, offSet + 1));
            ++offSet;
        }
        return new String(cnpjFormatado);
    }
}

